/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractEclipseManifestWriter
extends AbstractEclipseWriter {
    protected static final String MANIFEST_MF_FILENAME = "MANIFEST.MF";
    protected static final String META_INF_DIRECTORY = "META-INF";

    protected String orderClasspath(String newValue) {
        if (newValue == null) {
            return null;
        }
        Object[] entries = newValue.split(" ");
        Arrays.sort(entries);
        StringBuffer buffer = new StringBuffer(newValue.length());
        for (int index = 0; index < entries.length; ++index) {
            buffer.append((String)entries[index]);
            buffer.append(' ');
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest readExistingManifest(File manifestFile) throws IOException {
        if (!manifestFile.exists()) {
            return null;
        }
        Manifest existingManifest = new Manifest();
        FileInputStream inputStream = new FileInputStream(manifestFile);
        try {
            existingManifest.read(inputStream);
        }
        finally {
            IOUtil.close((InputStream)inputStream);
        }
        return existingManifest;
    }

    protected void addDependencyToClassPath(StringBuffer classpath, IdeDependency dependency) {
        if (!(dependency.isTestDependency() || dependency.isProvided() || dependency.isSystemScopedOutsideProject(this.config.getProject()))) {
            if (classpath.length() != 0) {
                classpath.append(' ');
            }
            if (!dependency.isReferencedProject()) {
                classpath.append(dependency.getFile().getName());
            } else {
                classpath.append(dependency.getEclipseProjectName()).append(".jar");
            }
        }
    }

    protected boolean areManifestsEqual(Manifest manifest, Manifest existingManifest) {
        if (existingManifest == null) {
            this.log.info((CharSequence)"@@@ FALSE - Manifest are not equal because existingManifest is null");
            return false;
        }
        HashSet<Object> keys = new HashSet<Object>();
        Attributes existingMap = existingManifest.getMainAttributes();
        Attributes newMap = manifest.getMainAttributes();
        keys.addAll(existingMap.keySet());
        keys.addAll(newMap.keySet());
        for (Attributes.Name name : keys) {
            String newValue = (String)newMap.get(name);
            String existingValue = (String)existingMap.get(name);
            if (Attributes.Name.CLASS_PATH.equals(name)) {
                newValue = this.orderClasspath(newValue);
                existingValue = this.orderClasspath(existingValue);
            }
            if (newValue != null && newValue.equals(existingValue) || existingValue != null && existingValue.equals(newValue)) continue;
            this.log.info((CharSequence)("@@@ FALSE - Manifest are not equal because key = " + name + " has existing value = " + existingValue + " and new value = " + newValue + " are different"));
            return false;
        }
        this.log.info((CharSequence)"@@@ TRUE - Manifests are equal");
        return true;
    }

    protected String constructManifestClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        IdeDependency[] deps = this.config.getDeps();
        for (int index = 0; index < deps.length; ++index) {
            this.addDependencyToClassPath(stringBuffer, deps[index]);
        }
        return stringBuffer.toString();
    }

    protected Manifest createNewManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, this.constructManifestClasspath());
        return manifest;
    }

    protected boolean shouldNewManifestFileBeWritten(Manifest manifest, File manifestFile) throws MojoExecutionException {
        try {
            Manifest existingManifest = this.readExistingManifest(manifestFile);
            if (this.areManifestsEqual(manifest, existingManifest)) {
                this.log.info((CharSequence)Messages.getString("EclipsePlugin.unchangedmanifest", manifestFile.getAbsolutePath()));
                return false;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", manifestFile.getAbsolutePath()), e);
        }
        return true;
    }

    protected abstract String getMetaInfBaseDirectory(MavenProject var1) throws MojoExecutionException;

    public void write() throws MojoExecutionException {
        String metaInfBaseDirectory = this.getMetaInfBaseDirectory(this.config.getProject());
        if (metaInfBaseDirectory == null) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", new Object[]{META_INF_DIRECTORY}));
        }
        File manifestFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY + File.separatorChar + MANIFEST_MF_FILENAME);
        Manifest manifest = this.createNewManifest();
        if (this.shouldNewManifestFileBeWritten(manifest, manifestFile)) {
            this.log.info((CharSequence)"Writing manifest...");
            manifestFile.getParentFile().mkdirs();
            try {
                FileOutputStream stream = new FileOutputStream(manifestFile);
                manifest.write(stream);
                stream.close();
            }
            catch (Exception e) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.cantwritetofile", new Object[]{manifestFile.getAbsolutePath()}));
            }
        }
    }
}

