/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.myeclipse;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class MyEclipseSpringBeansWriter
extends AbstractEclipseWriter {
    private static final String MYECLIPSE_SPRING_CONFIGURATION_FILENAME = ".springBeans";
    private static final String MYECLIPSE_SPRING_BEANS_PROJECT_DESCRIPTION = "beansProjectDescription";
    private static final String MYECLIPSE_SPRING_CONFIG_EXTENSIONS = "configExtensions";
    private static final String MYECLIPSE_SPRING_CONFIG_EXTENSION = "configExtension";
    private static final String MYECLIPSE_SPRING_CONFIGS = "configs";
    private static final String MYECLIPSE_SPRING_CONFIG = "config";
    private static final String MYECLIPSE_SPRING_CONFIGSETS = "configSets";
    private static final String MYECLIPSE_SPRING_VERSION = "springVersion";
    private Map springConfig;

    public MyEclipseSpringBeansWriter(Map springConfig) {
        this.springConfig = springConfig;
    }

    public void write() throws MojoExecutionException {
        FileWriter springFileWriter;
        try {
            springFileWriter = new FileWriter(new File(this.config.getEclipseProjectDirectory(), MYECLIPSE_SPRING_CONFIGURATION_FILENAME));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)springFileWriter, "UTF-8", null);
        writer.startElement(MYECLIPSE_SPRING_BEANS_PROJECT_DESCRIPTION);
        writer.startElement(MYECLIPSE_SPRING_CONFIG_EXTENSIONS);
        writer.startElement(MYECLIPSE_SPRING_CONFIG_EXTENSION);
        writer.writeText("xml");
        writer.endElement();
        writer.endElement();
        writer.startElement(MYECLIPSE_SPRING_CONFIGS);
        File basedir = this.config.getEclipseProjectDirectory();
        for (Object o : this.getConfigurationFilesList(new File(basedir, (String)this.springConfig.get("basedir")), (String)this.springConfig.get("file-pattern"))) {
            String onConfigFileName = (String)o;
            File onConfigFile = new File(onConfigFileName);
            String relativeFileName = IdeUtils.toRelativeAndFixSeparator(basedir, onConfigFile, false);
            writer.startElement(MYECLIPSE_SPRING_CONFIG);
            writer.writeText(relativeFileName);
            writer.endElement();
        }
        writer.endElement();
        writer.startElement(MYECLIPSE_SPRING_CONFIGSETS);
        writer.endElement();
        writer.startElement(MYECLIPSE_SPRING_VERSION);
        writer.writeText((String)this.springConfig.get("version"));
        writer.endElement();
        writer.endElement();
        IOUtil.close((Writer)springFileWriter);
    }

    private Collection getConfigurationFilesList(File basedir, String pattern) {
        ArrayList configFiles = new ArrayList();
        try {
            if (basedir.exists()) {
                this.log.debug((CharSequence)("Scanning " + basedir + " for spring definition files"));
                File[] subdirs = basedir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                if (subdirs != null) {
                    for (File subdir : subdirs) {
                        configFiles.addAll(this.getConfigurationFilesList(subdir, pattern));
                    }
                }
                configFiles.addAll(FileUtils.getFileNames((File)basedir, (String)pattern, null, (boolean)true));
            } else {
                this.log.warn((CharSequence)Messages.getString("MyEclipseSpringBeansWriter.baseDirDoesNotExist", new Object[]{basedir}));
            }
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)"Error while retrieving Spring configuration files. Returning list in current state");
        }
        Collections.sort(configFiles);
        return configFiles;
    }
}

