/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.reader;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.WorkspaceConfiguration;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWorkspaceLocations {
    public static final String BINARY_LOCATION_FILE = ".location";
    public static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    private static final String[] PARENT_VERSION = new String[]{"parent", "version"};
    private static final String[] PARENT_GROUP_ID = new String[]{"parent", "groupId"};
    private static final String[] PACKAGING = new String[]{"packaging"};
    private static final String[] VERSION = new String[]{"version"};
    private static final String[] GROUP_ID = new String[]{"groupId"};
    private static final String[] ARTEFACT_ID = new String[]{"artifactId"};
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_LAUNCHING_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.jdt.launching.prefs";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_VM_KEY = "org.eclipse.jdt.launching.PREF_VM_XML";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_SERVER_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/org.eclipse.wst.server.core.prefs";
    private static final String METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_RUNTIMES_KEY = "runtimes";
    private static final String CLASSPATHENTRY_DEFAULT = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String CLASSPATHENTRY_STANDARD = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/";
    private static final String CLASSPATHENTRY_FORMAT = "org.eclipse.jdt.launching.JRE_CONTAINER/{0}/{1}";

    public void init(Log log, WorkspaceConfiguration workspaceConfiguration, MavenProject project, String wtpDefaultServer, boolean preferStandardClasspathContainer) {
        workspaceConfiguration.setDefaultClasspathContainer(this.detectDefaultJREContainer(workspaceConfiguration, project, preferStandardClasspathContainer, log));
        this.readWorkspace(workspaceConfiguration, log);
        this.detectWTPDefaultServer(workspaceConfiguration, wtpDefaultServer, log);
    }

    private void detectWTPDefaultServer(WorkspaceConfiguration workspaceConfiguration, String wtpDefaultServer, Log log) {
        Map<String, String> servers = this.readDefinedServers(workspaceConfiguration, log);
        if (servers == null || servers.isEmpty()) {
            return;
        }
        if (wtpDefaultServer != null) {
            String name;
            String id;
            Set<String> ids = servers.keySet();
            Iterator<String> idIterator = ids.iterator();
            while (workspaceConfiguration.getDefaultDeployServerId() == null && idIterator.hasNext()) {
                id = idIterator.next();
                name = servers.get(id);
                if (!wtpDefaultServer.equals(id) && !wtpDefaultServer.equals(name)) continue;
                workspaceConfiguration.setDefaultDeployServerId(id);
                workspaceConfiguration.setDefaultDeployServerName(name);
            }
            if (workspaceConfiguration.getDefaultDeployServerId() == null) {
                log.info((CharSequence)"no exact wtp server match.");
                idIterator = ids.iterator();
                while (workspaceConfiguration.getDefaultDeployServerId() == null && idIterator.hasNext()) {
                    id = idIterator.next();
                    name = servers.get(id);
                    if (!id.contains(wtpDefaultServer) && !name.contains(wtpDefaultServer)) continue;
                    workspaceConfiguration.setDefaultDeployServerId(id);
                    workspaceConfiguration.setDefaultDeployServerName(name);
                }
            }
        }
        if (workspaceConfiguration.getDefaultDeployServerId() == null && servers.size() > 0) {
            log.info((CharSequence)"no substring wtp server match.");
            workspaceConfiguration.setDefaultDeployServerId(servers.get(""));
            workspaceConfiguration.setDefaultDeployServerName(servers.get(workspaceConfiguration.getDefaultDeployServerId()));
        }
        log.info((CharSequence)("Using as WTP server : " + workspaceConfiguration.getDefaultDeployServerName()));
    }

    private String getContainerFromExecutable(String rawExecutable, Map<String, String> jreMap, Log logger) {
        if (rawExecutable != null) {
            try {
                String executable = new File(rawExecutable).getCanonicalPath();
                logger.debug((CharSequence)("detected executable: " + executable));
            }
            catch (Exception e) {
                return null;
            }
            for (File executableFile = new File(executable); executableFile != null; executableFile = executableFile.getParentFile()) {
                String foundContainer = jreMap.get(executableFile.getPath());
                if (foundContainer == null) continue;
                logger.debug((CharSequence)("detected classpathContainer from executable: " + foundContainer));
                return foundContainer;
            }
        }
        return null;
    }

    private String detectDefaultJREContainer(WorkspaceConfiguration workspaceConfiguration, MavenProject project, boolean preferStandardClasspathContainer, Log logger) {
        File workspaceDirectory = workspaceConfiguration.getWorkspaceDirectory();
        Map<String, String> jreMap = this.readAvailableJREs(preferStandardClasspathContainer ? null : workspaceDirectory, logger);
        if (jreMap != null) {
            String foundContainer = null;
            if (preferStandardClasspathContainer && (foundContainer = this.getContainerFromSourceVersion(project, jreMap, logger)) != null) {
                return foundContainer;
            }
            foundContainer = this.getContainerFromExecutable(System.getProperty("maven.compiler.executable"), jreMap, logger);
            if (foundContainer != null) {
                return foundContainer;
            }
            foundContainer = this.getContainerFromExecutable(IdeUtils.getCompilerPluginSetting(project, "executable"), jreMap, logger);
            if (foundContainer != null) {
                return foundContainer;
            }
            if (!preferStandardClasspathContainer && (foundContainer = this.getContainerFromSourceVersion(project, jreMap, logger)) != null) {
                return foundContainer;
            }
            foundContainer = this.getContainerFromExecutable(System.getProperty("java.home"), jreMap, logger);
            if (foundContainer != null) {
                return foundContainer;
            }
        }
        return CLASSPATHENTRY_DEFAULT;
    }

    private String getContainerFromSourceVersion(MavenProject project, Map<String, String> jreMap, Log logger) {
        String sourceVersion = IdeUtils.getCompilerSourceVersion(project);
        String foundContainer = jreMap.get(sourceVersion);
        if (foundContainer != null) {
            logger.debug((CharSequence)("detected classpathContainer from sourceVersion(" + sourceVersion + "): " + foundContainer));
        }
        return foundContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getProjectLocation(File workspaceLocation, File project) throws IOException, URISyntaxException {
        File projectBase;
        File location = new File(project, BINARY_LOCATION_FILE);
        if (location.exists()) {
            DataInputStream dataInputStream;
            SafeChunkyInputStream fileInputStream;
            block5: {
                File file;
                fileInputStream = null;
                dataInputStream = null;
                try {
                    fileInputStream = new SafeChunkyInputStream(location);
                    dataInputStream = new DataInputStream((InputStream)fileInputStream);
                    String file2 = dataInputStream.readUTF().trim();
                    if (file2.length() <= 0) break block5;
                    if (!file2.startsWith("URI//")) {
                        throw new IOException(location.getAbsolutePath() + " contains unexpected data: " + file2);
                    }
                    file2 = file2.substring("URI//".length());
                    file = new File(new URI(file2));
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileInputStream);
                    IOUtil.close(dataInputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)fileInputStream);
                IOUtil.close((InputStream)dataInputStream);
                return file;
            }
            IOUtil.close((InputStream)fileInputStream);
            IOUtil.close((InputStream)dataInputStream);
        }
        if ((projectBase = new File(workspaceLocation, project.getName())).isDirectory()) {
            return projectBase;
        }
        return null;
    }

    private String getValue(Xpp3Dom element, String[] elementNames, String defaultValue) {
        String value = null;
        Xpp3Dom dom = element;
        for (int index = 0; dom != null && index < elementNames.length; dom = dom.getChild(elementNames[index]), ++index) {
        }
        if (dom != null) {
            value = dom.getValue();
        }
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    private IdeDependency readArtefact(File projectLocation, Log logger) throws XmlPullParserException, IOException {
        File pomFile;
        File projectFile = new File(projectLocation, ".project");
        String eclipseProjectName = projectLocation.getName();
        if (projectFile.exists()) {
            Xpp3Dom project = Xpp3DomBuilder.build((Reader)new FileReader(projectFile));
            eclipseProjectName = this.getValue(project, new String[]{"name"}, eclipseProjectName);
        }
        if ((pomFile = new File(projectLocation, "pom.xml")).exists()) {
            Xpp3Dom pom = Xpp3DomBuilder.build((Reader)new FileReader(pomFile));
            String artifact = this.getValue(pom, ARTEFACT_ID, null);
            String group = this.getValue(pom, GROUP_ID, this.getValue(pom, PARENT_GROUP_ID, null));
            String version = this.getValue(pom, VERSION, this.getValue(pom, PARENT_VERSION, null));
            String packaging = this.getValue(pom, PACKAGING, "jar");
            logger.debug((CharSequence)("found workspace artefact " + group + ":" + artifact + ":" + version + " " + packaging + " (" + eclipseProjectName + ")" + " -> " + projectLocation.getAbsolutePath()));
            return new IdeDependency(group, artifact, version, packaging, true, false, false, false, false, null, packaging, false, null, 0, eclipseProjectName);
        }
        logger.debug((CharSequence)("ignored workspace project NO pom available " + projectLocation.getAbsolutePath()));
        return null;
    }

    Map<String, String> readDefinedServers(WorkspaceConfiguration workspaceConfiguration, Log logger) {
        HashMap<String, String> detectedRuntimes = new HashMap<String, String>();
        if (workspaceConfiguration.getWorkspaceDirectory() != null) {
            Xpp3Dom runtimesElement = null;
            try {
                File prefs = new File(workspaceConfiguration.getWorkspaceDirectory(), METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_SERVER_PREFS);
                if (prefs.exists()) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(prefs));
                    String runtimes = properties.getProperty(METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_RUNTIMES_KEY);
                    if (runtimes != null) {
                        runtimesElement = Xpp3DomBuilder.build((Reader)new StringReader(runtimes));
                    }
                }
            }
            catch (Exception e) {
                logger.error((CharSequence)("Could not read workspace wtp server runtimes preferences : " + e.getMessage()));
            }
            if (runtimesElement != null) {
                Xpp3Dom[] runtimeArray = runtimesElement.getChildren("runtime");
                for (int index = 0; runtimeArray != null && index < runtimeArray.length; ++index) {
                    String id = runtimeArray[index].getAttribute("id");
                    String name = runtimeArray[index].getAttribute("name");
                    if (detectedRuntimes.isEmpty()) {
                        logger.debug((CharSequence)("Using WTP runtime with id: \"" + id + "\" as default runtime"));
                        detectedRuntimes.put("", id);
                    }
                    detectedRuntimes.put(id, name);
                    logger.debug((CharSequence)("Detected WTP runtime with id: \"" + id + "\" and name: \"" + name + "\""));
                }
            }
        }
        return detectedRuntimes;
    }

    private Map<String, String> readAvailableJREs(File workspaceLocation, Log logger) {
        Xpp3Dom[] vmTypes;
        Xpp3Dom vms;
        HashMap<String, String> jreMap = new HashMap<String, String>();
        jreMap.put("1.2", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.2");
        jreMap.put("1.3", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.3");
        jreMap.put("1.4", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.4");
        jreMap.put("1.5", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5");
        jreMap.put("5", (String)jreMap.get("1.5"));
        jreMap.put("1.6", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6");
        jreMap.put("6", (String)jreMap.get("1.6"));
        jreMap.put("1.7", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.7");
        jreMap.put("7", (String)jreMap.get("1.7"));
        jreMap.put("1.8", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8");
        jreMap.put("8", (String)jreMap.get("1.8"));
        if (workspaceLocation == null) {
            return jreMap;
        }
        try {
            File prefs = new File(workspaceLocation, METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_LAUNCHING_PREFS);
            if (!prefs.exists()) {
                return null;
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(prefs));
            vms = Xpp3DomBuilder.build((Reader)new StringReader(properties.getProperty(METADATA_PLUGINS_ORG_ECLIPSE_CORE_RUNTIME_PREFS_VM_KEY)));
        }
        catch (Exception e) {
            logger.error((CharSequence)"Could not read workspace JRE preferences", (Throwable)e);
            return null;
        }
        String defaultJRE = vms.getAttribute("defaultVM").trim();
        for (Xpp3Dom vmType : vmTypes = vms.getChildren("vmType")) {
            Xpp3Dom[] vm;
            String typeId = vmType.getAttribute("id");
            for (Xpp3Dom aVm : vm = vmType.getChildren("vm")) {
                try {
                    String path = aVm.getAttribute("path");
                    String name = aVm.getAttribute("name");
                    String vmId = aVm.getAttribute("id").trim();
                    String classpathEntry = MessageFormat.format(CLASSPATHENTRY_FORMAT, typeId, name);
                    String jrePath = new File(path).getCanonicalPath();
                    File rtJarFile = new File(new File(jrePath), "jre/lib/rt.jar");
                    if (!rtJarFile.exists()) {
                        logger.warn((CharSequence)Messages.getString("EclipsePlugin.invalidvminworkspace", jrePath));
                        continue;
                    }
                    JarFile rtJar = new JarFile(rtJarFile);
                    String version = rtJar.getManifest().getMainAttributes().getValue("Specification-Version");
                    if (defaultJRE.endsWith("," + vmId)) {
                        jreMap.put(jrePath, CLASSPATHENTRY_DEFAULT);
                        jreMap.put(version, CLASSPATHENTRY_DEFAULT);
                        logger.debug((CharSequence)("Default Classpath Container version: " + version + "  location: " + jrePath));
                        continue;
                    }
                    if (!jreMap.containsKey(jrePath)) {
                        if (!jreMap.containsKey(version)) {
                            jreMap.put(version, classpathEntry);
                        }
                        jreMap.put(jrePath, classpathEntry);
                        logger.debug((CharSequence)("Additional Classpath Container version: " + version + " " + classpathEntry + " location: " + jrePath));
                        continue;
                    }
                    logger.debug((CharSequence)("Ignored (duplicated) additional Classpath Container version: " + version + " " + classpathEntry + " location: " + jrePath));
                }
                catch (IOException e) {
                    logger.warn((CharSequence)("Could not interpret entry: " + aVm.toString()));
                }
            }
        }
        return jreMap;
    }

    public List<File> readProjectLocations(File workspaceDirectory, Log logger) {
        ArrayList<File> projectLocations = new ArrayList<File>();
        File projectsDirectory = new File(workspaceDirectory, METADATA_PLUGINS_ORG_ECLIPSE_CORE_RESOURCES_PROJECTS);
        if (projectsDirectory.exists()) {
            for (File project : projectsDirectory.listFiles()) {
                if (!project.isDirectory()) continue;
                try {
                    File projectLocation = this.getProjectLocation(workspaceDirectory, project);
                    if (projectLocation == null) continue;
                    projectLocations.add(projectLocation);
                }
                catch (Exception e) {
                    logger.warn((CharSequence)("could not read workspace project:" + project), (Throwable)e);
                }
            }
        }
        return projectLocations;
    }

    private void readWorkspace(WorkspaceConfiguration workspaceConfiguration, Log logger) {
        ArrayList<IdeDependency> dependencies = new ArrayList<IdeDependency>();
        File workspaceDirectory = workspaceConfiguration.getWorkspaceDirectory();
        if (workspaceDirectory != null) {
            for (File projectLocation : this.readProjectLocations(workspaceDirectory, logger)) {
                try {
                    logger.debug((CharSequence)("read workpsace project " + projectLocation));
                    IdeDependency ideDependency = this.readArtefact(projectLocation, logger);
                    if (ideDependency == null) continue;
                    dependencies.add(ideDependency);
                }
                catch (Exception e) {
                    logger.warn((CharSequence)("could not read workspace project from:" + projectLocation), (Throwable)e);
                }
            }
        }
        logger.debug((CharSequence)(dependencies.size() + " from workspace " + workspaceDirectory));
        workspaceConfiguration.setWorkspaceArtefacts(dependencies.toArray(new IdeDependency[dependencies.size()]));
    }
}

