/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.docck;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.docck.AbstractCheckDocumentationMojo;
import org.apache.maven.plugin.docck.reports.DocumentationReporter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="check", aggregator=true, defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class CheckPluginDocumentationMojo
extends AbstractCheckDocumentationMojo {
    @Component
    protected MojoScanner mojoScanner;
    private static final int MIN_DESCRIPTION_LENGTH = 1;

    @Override
    protected void checkPackagingSpecificDocumentation(MavenProject project, DocumentationReporter reporter) {
        List mojos;
        PluginDescriptor descriptor = new PluginDescriptor();
        try {
            this.mojoScanner.populatePluginDescriptor(project, descriptor);
        }
        catch (InvalidPluginDescriptorException e) {
            reporter.error("Failed to parse mojo descriptors.\nError: " + e.getMessage());
            descriptor = null;
        }
        catch (ExtractionException e) {
            reporter.error("Failed to parse mojo descriptors.\nError: " + e.getMessage());
            descriptor = null;
        }
        if (descriptor != null && (mojos = descriptor.getMojos()) != null && !mojos.isEmpty()) {
            for (MojoDescriptor mojo : mojos) {
                List params;
                String mojoDescription = mojo.getDescription();
                if (mojoDescription == null || mojoDescription.trim().length() < 1) {
                    reporter.error("Mojo: '" + mojo.getGoal() + "' is missing a description.");
                }
                if ((params = mojo.getParameters()) == null || params.isEmpty()) continue;
                for (Parameter param : params) {
                    String paramDescription;
                    if (param.getRequirement() != null || !param.isEditable() || (paramDescription = param.getDescription()) != null && paramDescription.trim().length() >= 1) continue;
                    reporter.error("Parameter: '" + param.getName() + "' in mojo: '" + mojo.getGoal() + "' is missing a description.");
                }
            }
        }
        this.checkConfiguredReportPlugins(project, reporter);
        this.checkProjectSite(project, reporter);
    }

    @Override
    protected boolean approveProjectPackaging(String packaging) {
        return "maven-plugin".equals(packaging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProjectSite(MavenProject project, DocumentationReporter reporter) {
        File projectSiteDirectory = new File(project.getBasedir(), this.siteDirectory);
        File siteXml = new File(projectSiteDirectory, "site.xml");
        if (!siteXml.exists()) {
            reporter.error("site.xml is missing.");
        } else {
            XmlStreamReader streamReader = null;
            try {
                streamReader = ReaderFactory.newXmlReader((File)siteXml);
                String siteHtml = IOUtil.toString((Reader)streamReader);
                if (!siteHtml.contains("href=\"index.html\"")) {
                    reporter.error("site.xml is missing the link to: index.html \"Introduction\".");
                }
                if (!siteHtml.contains("href=\"usage.html\"")) {
                    reporter.error("site.xml is missing the link to: usage.html \"Usage\".");
                }
                if (!siteHtml.contains("href=\"plugin-info.html\"")) {
                    reporter.error("site.xml is missing the link to: plugin-info.html \"Goals\".");
                }
                if (!siteHtml.contains("href=\"faq.html\"")) {
                    reporter.error("site.xml is missing the link to: faq.html \"FAQ\".");
                }
            }
            catch (IOException e) {
                reporter.error("Unable to read site.xml file: '" + siteXml.getAbsolutePath() + "'.\nError: " + e.getMessage());
            }
            finally {
                IOUtil.close((Reader)streamReader);
            }
        }
        if (!this.findFiles(projectSiteDirectory, "index")) {
            reporter.error("There is no 'index' file in your site directory (in apt|html|xml[.vm] format).");
        }
        if (!this.findFiles(projectSiteDirectory, "usage")) {
            reporter.error("There is no 'usage' file in your site directory (in apt|html|xml[.vm] format).");
        }
        if (!this.findFiles(projectSiteDirectory, "**/examples/*") && !this.findFiles(projectSiteDirectory, "**/example*")) {
            reporter.error("There are no example files in your site directory (in apt|html|xml[.vm] format). They should either be called 'example*.(apt|html|xml)[.vm]' or they should be located in the 'examples' directory.");
        }
        if (!this.findFiles(projectSiteDirectory, "faq")) {
            reporter.error("There is no 'faq' file in your site directory (in apt|fml|html|xml[.vm] format).");
        }
    }

    private void checkConfiguredReportPlugins(MavenProject project, DocumentationReporter reporter) {
        List<String> expectedPlugins = this.getRequiredPlugins();
        List reportPlugins = project.getReportPlugins();
        if (reportPlugins != null && reportPlugins.size() > 0) {
            for (ReportPlugin plugin : reportPlugins) {
                expectedPlugins.remove(plugin.getArtifactId());
            }
        } else {
            reporter.error("pom.xml has no report plugins configured.");
        }
        for (String expectedPlugin : expectedPlugins) {
            reporter.error("pom.xml is missing the report plugin: " + expectedPlugin + ".");
        }
    }

    private List<String> getRequiredPlugins() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("maven-javadoc-plugin");
        list.add("maven-jxr-plugin");
        return list;
    }
}

