/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.interpolation;

import java.io.File;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugins.assembly.io.DefaultAssemblyReader;
import org.apache.maven.plugins.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.InterpolationState;

public class AssemblyExpressionEvaluator
implements ExpressionEvaluator {
    private final AssemblerConfigurationSource configSource;
    private final FixedStringSearchInterpolator interpolator;
    private final PrefixAwareRecursionInterceptor interceptor;

    public AssemblyExpressionEvaluator(AssemblerConfigurationSource configSource) {
        this.configSource = configSource;
        MavenProject project = configSource.getProject();
        FixedStringSearchInterpolator projectInterpolator = DefaultAssemblyReader.createProjectInterpolator(project);
        this.interpolator = AssemblyInterpolator.fullInterpolator(project, projectInterpolator, configSource);
        this.interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
    }

    public File alignToBaseDirectory(File f) {
        String basePath = this.configSource.getBasedir().getAbsolutePath();
        String path = f.getPath();
        if (!f.isAbsolute() && !path.startsWith(basePath)) {
            return new File(this.configSource.getBasedir(), path);
        }
        return f;
    }

    public Object evaluate(String expression) throws ExpressionEvaluationException {
        InterpolationState is = new InterpolationState();
        is.setRecursionInterceptor((RecursionInterceptor)this.interceptor);
        return this.interpolator.interpolate(expression, is);
    }
}

