/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.InterpolationConstants;
import org.apache.maven.plugin.assembly.utils.ProjectUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public final class AssemblyFormatUtils {
    private AssemblyFormatUtils() {
    }

    public static String getDistributionName(Assembly assembly, AssemblerConfigurationSource configSource) {
        String finalName = configSource.getFinalName();
        boolean appendAssemblyId = configSource.isAssemblyIdAppended();
        String classifier = configSource.getClassifier();
        String distributionName = finalName;
        if (appendAssemblyId) {
            if (!StringUtils.isEmpty((String)assembly.getId())) {
                distributionName = finalName + "-" + assembly.getId();
            }
        } else if (classifier != null) {
            distributionName = finalName + "-" + classifier;
        }
        return distributionName;
    }

    @Deprecated
    public static String getOutputDirectory(String output, MavenProject mainProject, MavenProject artifactProject, String finalName) throws AssemblyFormattingException {
        return AssemblyFormatUtils.getOutputDirectory(output, mainProject, null, artifactProject, finalName, null);
    }

    public static String getOutputDirectory(String output, MavenProject mainProject, MavenProject artifactProject, String finalName, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        return AssemblyFormatUtils.getOutputDirectory(output, mainProject, null, artifactProject, finalName, configSource);
    }

    public static String getOutputDirectory(String output, MavenProject mainProject, MavenProject moduleProject, MavenProject artifactProject, String finalName, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        String value = output;
        if (value == null) {
            value = "";
        }
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        Properties specialExpressionOverrides = new Properties();
        if (finalName != null) {
            specialExpressionOverrides.setProperty("finalName", finalName);
            specialExpressionOverrides.setProperty("build.finalName", finalName);
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(specialExpressionOverrides));
        if (moduleProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("module.properties.", moduleProject.getProperties()));
            if (moduleProject.getArtifact() != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleProject.getArtifact()));
            }
        }
        if (artifactProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifactProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("artifact.properties.", artifactProject.getProperties()));
            if (artifactProject.getArtifact() != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifactProject.getArtifact()));
            }
        }
        MavenSession session = null;
        if (configSource != null && (session = configSource.getMavenSession()) != null) {
            Properties userProperties = null;
            try {
                userProperties = session.getExecutionProperties();
            }
            catch (NoSuchMethodError nsmer) {
                // empty catch block
            }
            if (userProperties != null) {
                interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(userProperties));
            }
        }
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)mainProject, true));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, mainProject.getProperties(), true));
        }
        Properties commandLineProperties = System.getProperties();
        if (session != null) {
            commandLineProperties = new Properties();
            if (session.getExecutionProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getExecutionProperties());
            }
            if (session.getUserProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
            }
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(commandLineProperties));
        try {
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(Collections.singletonList("env."), CommandLineUtils.getSystemEnvVars((boolean)false), true));
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Failed to retrieve OS environment variables. Reason: " + e.getMessage(), e);
        }
        try {
            value = interpolator.interpolate(value);
        }
        catch (InterpolationException e) {
            throw new AssemblyFormattingException("Failed to interpolate output directory. Reason: " + e.getMessage(), e);
        }
        if (value.length() > 0 && !value.endsWith("/") && !value.endsWith("\\")) {
            value = value + "/";
        }
        if (value.length() > 0 && (value.startsWith("/") || value.startsWith("\\"))) {
            value = value.substring(1);
        }
        value = StringUtils.replace((String)value, (String)"//", (String)"/");
        value = StringUtils.replace((String)value, (String)"\\\\", (String)"\\");
        value = AssemblyFormatUtils.fixRelativeRefs(value);
        return value;
    }

    @Deprecated
    public static String evaluateFileNameMapping(String expression, Artifact artifact, MavenProject mainProject, MavenProject artifactProject) throws AssemblyFormattingException {
        return AssemblyFormatUtils.evaluateFileNameMapping(expression, artifact, mainProject, null, null, artifactProject, null);
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact, MavenProject mainProject, MavenProject artifactProject, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        return AssemblyFormatUtils.evaluateFileNameMapping(expression, artifact, mainProject, null, null, artifactProject, configSource);
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact, MavenProject mainProject, MavenProject moduleProject, Artifact moduleArtifact, MavenProject artifactProject, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        String value = expression;
        artifact.isSnapshot();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        if (moduleArtifact != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleArtifact));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleArtifact.getArtifactHandler()));
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.handler.", (Object)moduleArtifact.getArtifactHandler()));
        }
        if (moduleProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("module.properties.", moduleProject.getProperties()));
            if (moduleProject.getArtifact() != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("module.", (Object)moduleProject.getArtifact()));
            }
        }
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifact));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifact.getArtifactHandler()));
        interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.handler.", (Object)artifact.getArtifactHandler()));
        if (artifactProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifactProject));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource("artifact.properties.", artifactProject.getProperties()));
            if (artifactProject.getArtifact() != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("artifact.", (Object)artifactProject.getArtifact()));
            }
        }
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)mainProject, true));
        }
        Properties specialRules = new Properties();
        String classifier = ProjectUtils.getClassifier(artifact);
        if (classifier != null) {
            specialRules.setProperty("dashClassifier?", "-" + classifier);
            specialRules.setProperty("dashClassifier", "-" + classifier);
        } else {
            specialRules.setProperty("dashClassifier?", "");
            specialRules.setProperty("dashClassifier", "");
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(specialRules));
        MavenSession session = null;
        if (configSource != null && (session = configSource.getMavenSession()) != null) {
            Properties userProperties = null;
            try {
                userProperties = session.getExecutionProperties();
            }
            catch (NoSuchMethodError nsmer) {
                // empty catch block
            }
            if (userProperties != null) {
                interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(userProperties));
            }
        }
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, mainProject.getProperties(), true));
        }
        Properties commandLineProperties = System.getProperties();
        if (session != null) {
            commandLineProperties = new Properties();
            if (session.getExecutionProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getExecutionProperties());
            }
            if (session.getUserProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
            }
        }
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(commandLineProperties));
        try {
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesValueSource(Collections.singletonList("env."), CommandLineUtils.getSystemEnvVars((boolean)false), true));
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Failed to retrieve OS environment variables. Reason: " + e.getMessage(), e);
        }
        try {
            value = interpolator.interpolate(value);
        }
        catch (InterpolationException e) {
            throw new AssemblyFormattingException("Failed to interpolate output filename mapping. Reason: " + e.getMessage(), e);
        }
        value = StringUtils.replace((String)value, (String)"//", (String)"/");
        value = StringUtils.replace((String)value, (String)"\\\\", (String)"\\");
        value = AssemblyFormatUtils.fixRelativeRefs(value);
        return value;
    }

    public static String fixRelativeRefs(String src) {
        String value = src;
        String[] separators = new String[]{"/", "\\"};
        String finalSep = null;
        for (String sep : separators) {
            if (value.endsWith(sep)) {
                finalSep = sep;
            }
            if (value.indexOf("." + sep) <= -1) continue;
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(Arrays.asList(value.split(sep)));
            ListIterator it = parts.listIterator();
            while (it.hasNext()) {
                String part = (String)it.next();
                if (".".equals(part)) {
                    it.remove();
                    continue;
                }
                if (!"..".equals(part)) continue;
                it.remove();
                if (!it.hasPrevious()) continue;
                it.previous();
                it.remove();
            }
            value = StringUtils.join(parts.iterator(), (String)sep);
        }
        if (finalSep != null && value.length() > 0 && !value.endsWith(finalSep)) {
            value = value + finalSep;
        }
        return value;
    }
}

