/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugin.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyResolver.class)
public class DefaultDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    @Requirement
    private ArtifactResolver resolver;
    @Requirement
    private ArtifactMetadataSource metadataSource;
    @Requirement
    private ArtifactFactory factory;
    @Requirement
    private ArtifactCollector collector;

    public DefaultDependencyResolver() {
    }

    protected DefaultDependencyResolver(ArtifactResolver resolver, ArtifactMetadataSource metadataSource, ArtifactFactory factory, ArtifactCollector collector, Logger logger) {
        this.resolver = resolver;
        this.metadataSource = metadataSource;
        this.factory = factory;
        this.collector = collector;
        this.enableLogging(logger);
    }

    @Override
    public void resolve(Assembly assembly, AssemblerConfigurationSource configSource, AssemblyContext context) throws DependencyResolutionException {
        MavenProject currentProject = configSource.getProject();
        ResolutionManagementInfo info = new ResolutionManagementInfo(currentProject);
        this.getRepositoryResolutionRequirements(assembly, info, currentProject);
        this.getDependencySetResolutionRequirements(assembly, assembly.getDependencySets(), info, currentProject);
        this.getModuleSetResolutionRequirements(assembly, info, configSource);
        if (!info.isResolutionRequired()) {
            context.setResolvedArtifacts(new HashSet<Artifact>());
            return;
        }
        List<ArtifactRepository> repos = this.aggregateRemoteArtifactRepositories(configSource.getRemoteRepositories(), info.getEnabledProjects());
        Set<Artifact> artifacts = info.getArtifacts();
        if (info.isResolvedTransitively()) {
            this.getLogger().debug("Resolving project dependencies transitively.");
            artifacts = this.resolveTransitively(artifacts, repos, info, configSource);
        } else {
            this.getLogger().debug("Resolving project dependencies ONLY. Transitive dependencies WILL NOT be included in the results.");
            artifacts = this.resolveNonTransitively(assembly, artifacts, configSource, repos);
        }
        context.setResolvedArtifacts(artifacts);
    }

    protected Set<Artifact> resolveNonTransitively(Assembly assembly, Set<Artifact> dependencyArtifacts, AssemblerConfigurationSource configSource, List<ArtifactRepository> repos) throws DependencyResolutionException {
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>();
        for (Artifact depArtifact : dependencyArtifacts) {
            try {
                this.resolver.resolve(depArtifact, repos, configSource.getLocalRepository());
                resolved.add(depArtifact);
            }
            catch (ArtifactResolutionException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve: " + depArtifact.getId() + " for assembly: " + assembly.getId());
                }
                missing.add(depArtifact);
            }
            catch (ArtifactNotFoundException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Failed to resolve: " + depArtifact.getId() + " for assembly: " + assembly.getId());
                }
                missing.add(depArtifact);
            }
        }
        if (!missing.isEmpty()) {
            MavenProject project = configSource.getProject();
            Artifact rootArtifact = project.getArtifact();
            MultipleArtifactsNotFoundException error = new MultipleArtifactsNotFoundException(rootArtifact, new ArrayList<Artifact>(resolved), missing, repos);
            throw new DependencyResolutionException("Failed to resolve dependencies for: " + assembly.getId(), (Throwable)error);
        }
        return resolved;
    }

    private Set<Artifact> resolveTransitively(Set<Artifact> dependencyArtifacts, List<ArtifactRepository> repos, ResolutionManagementInfo info, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ArtifactResolutionResult result;
        MavenProject project = configSource.getProject();
        ScopeArtifactFilter filter = info.getScopeFilter();
        ArtifactRepository localRepository = configSource.getLocalRepository();
        try {
            result = this.resolver.resolveTransitively(dependencyArtifacts, project.getArtifact(), project.getManagedVersionMap(), localRepository, repos, this.metadataSource, (ArtifactFilter)filter);
        }
        catch (ArtifactResolutionException e) {
            throw new DependencyResolutionException("Failed to resolve dependencies for assembly: ", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DependencyResolutionException("Failed to resolve dependencies for assembly: ", e);
        }
        this.getLogger().debug("While resolving dependencies of " + project.getId() + ":");
        FilterUtils.reportFilteringStatistics(Collections.singleton(filter), this.getLogger());
        return result.getArtifacts();
    }

    protected void getRepositoryResolutionRequirements(Assembly assembly, ResolutionManagementInfo requirements, MavenProject ... project) {
        List<Repository> repositories = assembly.getRepositories();
        if (repositories != null && !repositories.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (Repository repo : repositories) {
                this.enableScope(repo.getScope(), requirements);
            }
        }
    }

    protected void getModuleSetResolutionRequirements(Assembly assembly, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        List<ModuleSet> moduleSets = assembly.getModuleSets();
        if (moduleSets != null && !moduleSets.isEmpty()) {
            for (ModuleSet set : moduleSets) {
                Set<MavenProject> projects;
                ModuleBinaries binaries = set.getBinaries();
                if (binaries == null) continue;
                try {
                    projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, this.getLogger());
                }
                catch (ArchiveCreationException e) {
                    throw new DependencyResolutionException("Error determining project-set for moduleSet with binaries.", e);
                }
                if (projects != null && !projects.isEmpty()) {
                    for (MavenProject p : projects) {
                        requirements.enableProjectResolution(p);
                        if (p.getArtifact() != null) continue;
                        Artifact artifact = this.factory.createBuildArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion(), p.getPackaging());
                        p.setArtifact(artifact);
                    }
                }
                if (!binaries.isIncludeDependencies()) continue;
                this.getDependencySetResolutionRequirements(assembly, ModuleSetAssemblyPhase.getDependencySets(binaries), requirements, projects.toArray(new MavenProject[projects.size()]));
            }
        }
    }

    protected void getDependencySetResolutionRequirements(Assembly assembly, List<DependencySet> depSets, ResolutionManagementInfo requirements, MavenProject ... projects) throws DependencyResolutionException {
        if (depSets != null && !depSets.isEmpty()) {
            requirements.setResolutionRequired(true);
            for (DependencySet set : depSets) {
                requirements.setResolvedTransitively(set.isUseTransitiveDependencies());
                this.enableScope(set.getScope(), requirements);
            }
            for (MavenProject project : projects) {
                if (project == null) continue;
                Set dependencyArtifacts = project.getDependencyArtifacts();
                if (dependencyArtifacts == null) {
                    try {
                        dependencyArtifacts = project.createArtifacts(this.factory, null, (ArtifactFilter)requirements.getScopeFilter());
                        project.setDependencyArtifacts(dependencyArtifacts);
                    }
                    catch (InvalidDependencyVersionException e) {
                        throw new DependencyResolutionException("Failed to create dependency artifacts for resolution. Assembly: " + assembly.getId(), e);
                    }
                }
                requirements.addArtifacts(dependencyArtifacts);
                this.getLogger().debug("Dependencies for project: " + project.getId() + " are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
            }
        }
    }

    private void enableScope(String scope, ResolutionManagementInfo requirements) {
        if ("compile".equals(scope)) {
            requirements.enableCompileScope();
        } else if ("provided".equals(scope)) {
            requirements.enableProvidedScope();
        } else if ("runtime".equals(scope)) {
            requirements.enableRuntimeScope();
        } else if ("system".equals(scope)) {
            requirements.enableSystemScope();
        } else if ("test".equals(scope)) {
            requirements.enableTestScope();
        }
    }

    protected List<ArtifactRepository> aggregateRemoteArtifactRepositories(List<ArtifactRepository> remoteRepositories, Set<MavenProject> projects) {
        ArrayList<List> repoLists = new ArrayList<List>();
        repoLists.add(remoteRepositories);
        for (MavenProject project : projects) {
            repoLists.add(project.getRemoteArtifactRepositories());
        }
        ArrayList<ArtifactRepository> remoteRepos = new ArrayList<ArtifactRepository>();
        HashSet<String> encounteredUrls = new HashSet<String>();
        for (List repositoryList : repoLists) {
            if (repositoryList == null || repositoryList.isEmpty()) continue;
            for (ArtifactRepository repo : repositoryList) {
                if (encounteredUrls.contains(repo.getUrl())) continue;
                remoteRepos.add(repo);
                encounteredUrls.add(repo.getUrl());
            }
        }
        return remoteRepos;
    }

    protected ArtifactResolver getArtifactResolver() {
        return this.resolver;
    }

    protected DefaultDependencyResolver setArtifactResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    protected ArtifactMetadataSource getArtifactMetadataSource() {
        return this.metadataSource;
    }

    protected DefaultDependencyResolver setArtifactMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
        return this;
    }

    protected ArtifactFactory getArtifactFactory() {
        return this.factory;
    }

    protected DefaultDependencyResolver setArtifactFactory(ArtifactFactory factory) {
        this.factory = factory;
        return this;
    }

    protected ArtifactCollector getArtifactCollector() {
        return this.collector;
    }

    protected DefaultDependencyResolver setArtifactCollector(ArtifactCollector collector) {
        this.collector = collector;
        return this;
    }

    protected DefaultDependencyResolver setLogger(Logger logger) {
        this.enableLogging(logger);
        return this;
    }
}

