/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         Configures a filter for files headed into the assembly
 * archive, to enable
 *         aggregation of various types of descriptor fragments,
 * such as components.xml,
 *         web.xml, etc.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ContainerDescriptorHandlerConfig
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     */
    private String handlerName;

    /**
     * 
     *             Configuration options for the handler.
     *           
     */
    private Object configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Configuration options for the handler.
     *           
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration()

    /**
     * Get 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     * 
     * @return String
     */
    public String getHandlerName()
    {
        return this.handlerName;
    } //-- String getHandlerName()

    /**
     * Set 
     *             Configuration options for the handler.
     *           
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object )

    /**
     * Set 
     *             The handler's plexus role-hint, for lookup from
     * the container.
     *           
     * 
     * @param handlerName
     */
    public void setHandlerName( String handlerName )
    {
        this.handlerName = handlerName;
    } //-- void setHandlerName( String )


}
