/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.AbstractBuildinfoMojo;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.plugins.artifact.buildinfo.ReferenceBuildinfoUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.PropertyUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="compare", threadSafe=true)
public class CompareMojo
extends AbstractBuildinfoMojo {
    @Parameter(property="reference.repo", defaultValue="central")
    private String referenceRepo;
    @Parameter(property="compare.aggregate.only", defaultValue="false")
    private boolean aggregateOnly;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Component
    private ArtifactRepositoryLayout artifactRepositoryLayout;

    @Override
    public void execute(Map<Artifact, String> artifacts) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Checking against reference build from " + this.referenceRepo + "..."));
        this.checkAgainstReference(artifacts, this.reactorProjects.size() == 1);
    }

    @Override
    protected void skip(MavenProject last) throws MojoExecutionException {
        if (this.aggregateOnly) {
            return;
        }
        this.checkAgainstReference(this.generateBuildinfo(true), true);
    }

    private void checkAgainstReference(Map<Artifact, String> artifacts, boolean mono) throws MojoExecutionException {
        MavenProject root = mono ? this.project : this.getExecutionRoot();
        File referenceDir = new File(root.getBuild().getDirectory(), "reference");
        referenceDir.mkdirs();
        File referenceBuildinfo = this.downloadOrCreateReferenceBuildinfo(mono, artifacts, referenceDir);
        this.compareWithReference(artifacts, referenceBuildinfo);
    }

    private File downloadOrCreateReferenceBuildinfo(boolean mono, Map<Artifact, String> artifacts, File referenceDir) throws MojoExecutionException {
        RemoteRepository repo = this.createReferenceRepo();
        ReferenceBuildinfoUtil rmb = new ReferenceBuildinfoUtil(this.getLog(), referenceDir, artifacts, this.artifactFactory, this.repoSystem, this.repoSession, this.artifactHandlerManager, this.rtInformation);
        return rmb.downloadOrCreateReferenceBuildinfo(repo, this.project, this.buildinfoFile, mono);
    }

    private void compareWithReference(Map<Artifact, String> artifacts, File referenceBuildinfo) throws MojoExecutionException {
        int missing;
        Properties actual = BuildInfoWriter.loadOutputProperties(this.buildinfoFile);
        Properties reference = BuildInfoWriter.loadOutputProperties(referenceBuildinfo);
        int ok = 0;
        ArrayList<String> okFilenames = new ArrayList<String>();
        ArrayList<String> koFilenames = new ArrayList<String>();
        ArrayList<String> diffoscopes = new ArrayList<String>();
        File referenceDir = referenceBuildinfo.getParentFile();
        for (Map.Entry<Artifact, String> entry : artifacts.entrySet()) {
            Artifact artifact = entry.getKey();
            String prefix = entry.getValue();
            String[] checkResult = this.checkArtifact(artifact, prefix, reference, actual, referenceDir);
            String filename = checkResult[0];
            String diffoscope = checkResult[1];
            if (diffoscope == null) {
                ++ok;
                okFilenames.add(filename);
                continue;
            }
            koFilenames.add(filename);
            diffoscopes.add(diffoscope);
        }
        int ko = artifacts.size() - ok;
        if (ko + (missing = reference.size() / 3) > 0) {
            this.getLog().error((CharSequence)("Reproducible Build output summary: " + MessageUtils.buffer().success((Object)(ok + " files ok")) + ", " + MessageUtils.buffer().failure((Object)(ko + " different")) + (missing == 0 ? "" : ", " + MessageUtils.buffer().failure((Object)(missing + " missing")))));
            this.getLog().error((CharSequence)("see " + MessageUtils.buffer().project((Object)("diff " + this.relative(referenceBuildinfo) + " " + this.relative(this.buildinfoFile))).toString()));
            this.getLog().error((CharSequence)"see also https://maven.apache.org/guides/mini/guide-reproducible-builds.html");
        } else {
            this.getLog().info((CharSequence)("Reproducible Build output summary: " + MessageUtils.buffer().success((Object)(ok + " files ok"))));
        }
        File buildcompare = new File(this.buildinfoFile.getParentFile(), this.buildinfoFile.getName().replaceFirst(".buildinfo$", ".buildcompare"));
        try (PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(buildcompare), StandardCharsets.UTF_8)));){
            p.println("version=" + this.project.getVersion());
            p.println("ok=" + ok);
            p.println("ko=" + ko);
            p.println("okFiles=\"" + StringUtils.join(okFilenames.iterator(), (String)" ") + '\"');
            p.println("koFiles=\"" + StringUtils.join(koFilenames.iterator(), (String)" ") + '\"');
            Properties ref = PropertyUtils.loadOptionalProperties((File)referenceBuildinfo);
            String v = ref.getProperty("java.version");
            if (v != null) {
                p.println("reference_java_version=\"" + v + '\"');
            }
            if ((v = ref.getProperty("os.name")) != null) {
                p.println("reference_os_name=\"" + v + '\"');
            }
            for (String diffoscope : diffoscopes) {
                p.print("# ");
                p.println(diffoscope);
            }
            this.getLog().info((CharSequence)("Reproducible Build output comparison saved to " + buildcompare));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + buildcompare, (Exception)e);
        }
        this.copyAggregateToRoot(buildcompare);
        if (ko + missing > 0) {
            throw new MojoExecutionException("Build artifacts are different from reference");
        }
    }

    private String[] checkArtifact(Artifact artifact, String prefix, Properties reference, Properties actual, File referenceDir) {
        String actualFilename = (String)actual.remove(prefix + ".filename");
        String actualLength = (String)actual.remove(prefix + ".length");
        String actualSha512 = (String)actual.remove(prefix + ".checksums.sha512");
        String referencePrefix = CompareMojo.findPrefix(reference, actualFilename);
        String referenceLength = (String)reference.remove(referencePrefix + ".length");
        String referenceSha512 = (String)reference.remove(referencePrefix + ".checksums.sha512");
        String issue = null;
        if (!actualLength.equals(referenceLength)) {
            issue = "size";
        } else if (!actualSha512.equals(referenceSha512)) {
            issue = "sha512";
        }
        if (issue != null) {
            String diffoscope = this.diffoscope(artifact, referenceDir);
            this.getLog().error((CharSequence)(issue + " mismatch " + MessageUtils.buffer().strong((Object)actualFilename) + ": investigate with " + MessageUtils.buffer().project((Object)diffoscope)));
            return new String[]{actualFilename, diffoscope};
        }
        return new String[]{actualFilename, null};
    }

    private String diffoscope(Artifact a, File referenceDir) {
        File actual = a.getFile();
        File reference = new File(referenceDir, this.getRepositoryFilename(a));
        if (actual == null || reference == null) {
            return "missing file for " + a.getId() + " reference = " + (reference == null ? "null" : this.relative(reference)) + " actual = " + (actual == null ? "null" : this.relative(actual));
        }
        return "diffoscope " + this.relative(reference) + " " + this.relative(actual);
    }

    private String getRepositoryFilename(Artifact a) {
        String path = this.artifactRepositoryLayout.pathOf(a);
        return path.substring(path.lastIndexOf(47));
    }

    private String relative(File file) {
        File basedir = this.getExecutionRoot().getBasedir();
        int length = basedir.getPath().length();
        String path = file.getPath();
        return path.substring(length + 1);
    }

    private static String findPrefix(Properties reference, String actualFilename) {
        for (String name : reference.stringPropertyNames()) {
            if (!name.endsWith(".filename") || !actualFilename.equals(reference.getProperty(name))) continue;
            reference.remove(name);
            return name.substring(0, name.length() - ".filename".length());
        }
        return null;
    }

    private RemoteRepository createReferenceRepo() throws MojoExecutionException {
        if (this.referenceRepo.contains("::")) {
            int index = this.referenceRepo.indexOf("::");
            String id = this.referenceRepo.substring(0, index);
            String url = this.referenceRepo.substring(index + 2);
            return CompareMojo.createDeploymentArtifactRepository(id, url);
        }
        if (this.referenceRepo.contains(":")) {
            return CompareMojo.createDeploymentArtifactRepository("reference", this.referenceRepo);
        }
        for (RemoteRepository repo : this.remoteRepos) {
            if (!this.referenceRepo.equals(repo.getId())) continue;
            return repo;
        }
        throw new MojoExecutionException("Could not find repository with id = " + this.referenceRepo);
    }

    private static RemoteRepository createDeploymentArtifactRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).build();
    }
}

