/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static String[] findSources(String basedir, String include) {
        return PluginUtils.findSources(basedir, include, null);
    }

    public static String[] findSources(String basedir, String include, String exclude) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(new String[]{include});
        if (exclude != null && !exclude.isEmpty()) {
            scanner.setExcludes(new String[]{exclude, StringUtils.join((Object[])FileUtils.getDefaultExcludes(), (String)",")});
        } else {
            scanner.setExcludes(FileUtils.getDefaultExcludes());
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static void sortMojos(List<MojoDescriptor> mojoDescriptors) {
        if (mojoDescriptors != null) {
            Collections.sort(mojoDescriptors, new Comparator<MojoDescriptor>(){

                @Override
                public int compare(MojoDescriptor mojo0, MojoDescriptor mojo1) {
                    return mojo0.getGoal().compareToIgnoreCase(mojo1.getGoal());
                }
            });
        }
    }

    public static void sortMojoParameters(List<Parameter> parameters) {
        if (parameters != null) {
            Collections.sort(parameters, new Comparator<Parameter>(){

                @Override
                public int compare(Parameter parameter1, Parameter parameter2) {
                    return parameter1.getName().compareToIgnoreCase(parameter2.getName());
                }
            });
        }
    }

    public static boolean isMavenReport(String mojoClassName, MavenProject project) throws IllegalArgumentException {
        if (mojoClassName == null) {
            throw new IllegalArgumentException("mojo implementation should be declared");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (project != null) {
            List classPathStrings;
            try {
                classPathStrings = project.getCompileClasspathElements();
                if (project.getExecutionProject() != null) {
                    classPathStrings.addAll(project.getExecutionProject().getCompileClasspathElements());
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new IllegalArgumentException(e);
            }
            ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
            for (String classPathString : classPathStrings) {
                try {
                    urls.add(new File(classPathString).toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
        }
        try {
            Class<?> clazz = Class.forName(mojoClassName, false, classLoader);
            return MavenReport.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

