/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.registry.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.registry.Plugin;
import org.apache.maven.plugin.registry.PluginRegistry;
import org.apache.maven.plugin.registry.TrackableBase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class PluginRegistryXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, PluginRegistry pluginRegistry) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.serializer.startDocument(pluginRegistry.getModelEncoding(), null);
        this.writePluginRegistry(pluginRegistry, "pluginRegistry", this.serializer);
        this.serializer.endDocument();
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        if (plugin != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (plugin.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(plugin.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (plugin.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(plugin.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (plugin.getLastChecked() != null) {
                serializer.startTag(this.NAMESPACE, "lastChecked").text(plugin.getLastChecked()).endTag(this.NAMESPACE, "lastChecked");
            }
            if (plugin.getUseVersion() != null) {
                serializer.startTag(this.NAMESPACE, "useVersion").text(plugin.getUseVersion()).endTag(this.NAMESPACE, "useVersion");
            }
            if (plugin.getRejectedVersions() != null && plugin.getRejectedVersions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "rejectedVersions");
                Iterator iter = plugin.getRejectedVersions().iterator();
                while (iter.hasNext()) {
                    String rejectedVersion = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "rejectedVersion").text(rejectedVersion).endTag(this.NAMESPACE, "rejectedVersion");
                }
                serializer.endTag(this.NAMESPACE, "rejectedVersions");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginRegistry(PluginRegistry pluginRegistry, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginRegistry != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginRegistry.getUpdateInterval() != null && !pluginRegistry.getUpdateInterval().equals("never")) {
                serializer.startTag(this.NAMESPACE, "updateInterval").text(pluginRegistry.getUpdateInterval()).endTag(this.NAMESPACE, "updateInterval");
            }
            if (pluginRegistry.getAutoUpdate() != null) {
                serializer.startTag(this.NAMESPACE, "autoUpdate").text(pluginRegistry.getAutoUpdate()).endTag(this.NAMESPACE, "autoUpdate");
            }
            if (pluginRegistry.getCheckLatest() != null) {
                serializer.startTag(this.NAMESPACE, "checkLatest").text(pluginRegistry.getCheckLatest()).endTag(this.NAMESPACE, "checkLatest");
            }
            if (pluginRegistry.getPlugins() != null && pluginRegistry.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = pluginRegistry.getPlugins().iterator();
                while (iter.hasNext()) {
                    Plugin plugin = (Plugin)iter.next();
                    this.writePlugin(plugin, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer) throws IOException {
        if (trackableBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

