/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         Describes a build extension to utilise.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Extension implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The artifact ID of the extension.
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get 
     *             The group ID of the extension's artifact.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get The version of the extension.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set The artifact ID of the extension.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             The group ID of the extension's artifact.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set The version of the extension.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }

        if ( !( o instanceof Extension ) )
        {
            return false;
        }

        Extension e = (Extension) o;

        if ( !e.getArtifactId().equals( getArtifactId() ) )
        {
            return false;
        }
        else if ( !e.getGroupId().equals( getGroupId() ) )
        {
            return false;
        }
        else if ( e.getVersion() != null ? !e.getVersion().equals( getVersion() ) : getVersion() != null )
        {
            return false;
        }
        return true;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        int result = 17;
        result = 37 * result + getArtifactId() != null ? getArtifactId().hashCode() : 0;
        result = 37 * result + getGroupId() != null ? getGroupId().hashCode() : 0;
        result = 37 * result + getVersion() != null ? getVersion().hashCode() : 0;
        return result;
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
