/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Prerequisites
implements Serializable,
InputLocationTracker {
    final String maven;
    final InputLocation location;
    final InputLocation mavenLocation;
    final Map<Object, InputLocation> locations;

    Prerequisites(String maven, Map<Object, InputLocation> locations, InputLocation location, InputLocation mavenLocation) {
        this.maven = maven;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.mavenLocation = mavenLocation;
    }

    public String getMaven() {
        return this.maven;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "maven": {
                    return this.mavenLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Prerequisites.newBuilder(this);
    }

    @Nonnull
    public Prerequisites withMaven(String maven) {
        return this.with().maven(maven).build();
    }

    @Nonnull
    public static Prerequisites newInstance() {
        return Prerequisites.newInstance(true);
    }

    @Nonnull
    public static Prerequisites newInstance(boolean withDefaults) {
        return Prerequisites.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Prerequisites.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Prerequisites from) {
        return Prerequisites.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Prerequisites from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Prerequisites base;
        String maven;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.maven = "2.0";
            }
        }

        Builder(Prerequisites base, boolean forceCopy) {
            if (forceCopy) {
                this.maven = base.maven;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder maven(String maven) {
            this.maven = maven;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Prerequisites build() {
            if (this.base != null && (this.maven == null || this.maven == this.base.maven)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation mavenLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                mavenLocation = locations.remove("maven");
            }
            return new Prerequisites(this.maven != null ? this.maven : (this.base != null ? this.base.maven : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), mavenLocation != null ? mavenLocation : (this.base != null ? this.base.mavenLocation : null));
        }
    }
}

