/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Exclusion
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final InputLocation location;
    final InputLocation groupIdLocation;
    final InputLocation artifactIdLocation;
    final Map<Object, InputLocation> locations;

    Exclusion(String groupId, String artifactId, Map<Object, InputLocation> locations, InputLocation location, InputLocation groupIdLocation, InputLocation artifactIdLocation) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Exclusion.newBuilder(this);
    }

    @Nonnull
    public Exclusion withGroupId(String groupId) {
        return this.with().groupId(groupId).build();
    }

    @Nonnull
    public Exclusion withArtifactId(String artifactId) {
        return this.with().artifactId(artifactId).build();
    }

    @Nonnull
    public static Exclusion newInstance() {
        return Exclusion.newInstance(true);
    }

    @Nonnull
    public static Exclusion newInstance(boolean withDefaults) {
        return Exclusion.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Exclusion.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Exclusion from) {
        return Exclusion.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Exclusion from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Exclusion base;
        String groupId;
        String artifactId;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Exclusion base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Exclusion build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                groupIdLocation = locations.remove("groupId");
                artifactIdLocation = locations.remove("artifactId");
            }
            return new Exclusion(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), groupIdLocation != null ? groupIdLocation : (this.base != null ? this.base.groupIdLocation : null), artifactIdLocation != null ? artifactIdLocation : (this.base != null ? this.base.artifactIdLocation : null));
        }
    }
}

