/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class Key<T>
implements StringBuilderFormattable {
    private final Type type;
    private final Class<T> rawType;
    private final Class<? extends Annotation> qualifierType;
    private final String name;
    private final String namespace;
    private final int order;
    private final int hashCode;
    private String toString;
    private static final String TO_STRING_PREFIX = "Key[type: ";
    private static final String NAMESPACE = "; namespace: ";
    private static final String NAME = "; name: ";
    private static final String QUALIFIER_TYPE = "; qualifierType: ";

    protected Key() {
        this.type = TypeUtil.getSuperclassTypeParameter(this.getClass());
        this.rawType = (Class)Cast.cast(TypeUtil.getRawType(this.type));
        AnnotatedType superclass = this.getClass().getAnnotatedSuperclass();
        Annotation qualifier = AnnotationUtil.getMetaAnnotation(superclass, QualifierType.class);
        this.qualifierType = qualifier != null ? qualifier.annotationType() : null;
        this.name = Keys.getName(superclass);
        this.namespace = Keys.getNamespace(superclass);
        this.order = Key.getOrder(superclass);
        this.hashCode = Objects.hash(this.type, this.qualifierType, this.name.toLowerCase(Locale.ROOT), this.namespace.toLowerCase(Locale.ROOT));
    }

    private Key(Type type, Class<T> rawType, Class<? extends Annotation> qualifierType, String name, String namespace, int order) {
        this.type = type;
        this.rawType = rawType;
        this.qualifierType = qualifierType;
        this.name = name;
        this.namespace = namespace;
        this.order = order;
        this.hashCode = Objects.hash(type, qualifierType, name.toLowerCase(Locale.ROOT), namespace.toLowerCase(Locale.ROOT));
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final Class<? extends Annotation> getQualifierType() {
        return this.qualifierType;
    }

    public final int getOrder() {
        return this.order;
    }

    public final Key<T> withName(String name) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, name, this.namespace, this.order);
    }

    public final Key<T> withNamespace(String namespace) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, this.name, namespace, this.order);
    }

    public final Key<T> withQualifierType(Class<? extends Annotation> qualifierType) {
        return new Key<T>(this.type, this.rawType, qualifierType, this.name, this.namespace, this.order);
    }

    public final <P> Key<P> getSuppliedType() {
        if (this.type instanceof ParameterizedType && Supplier.class.isAssignableFrom(this.rawType)) {
            Type typeArgument = ((ParameterizedType)this.type).getActualTypeArguments()[0];
            Class rawType = (Class)Cast.cast(TypeUtil.getRawType(typeArgument));
            return new Key<T>(typeArgument, rawType, this.qualifierType, this.name, this.namespace, this.order);
        }
        return null;
    }

    public final <P> Key<P> getParameterizedTypeArgument(int arg) {
        if (this.type instanceof ParameterizedType) {
            Type typeArgument = ((ParameterizedType)this.type).getActualTypeArguments()[arg];
            Class rawType = (Class)Cast.cast(TypeUtil.getRawType(typeArgument));
            return new Key<T>(typeArgument, rawType, this.qualifierType, this.name, this.namespace, this.order);
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return TypeUtil.isEqual(this.type, that.type) && this.name.equalsIgnoreCase(that.name) && this.namespace.equalsIgnoreCase(that.namespace) && Objects.equals(this.qualifierType, that.qualifierType);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        String string = this.toString;
        if (string == null) {
            StringBuilder sb = new StringBuilder(32);
            this.formatTo(sb);
            this.toString = string = sb.toString();
        }
        return string;
    }

    public void formatTo(StringBuilder buffer) {
        buffer.append(TO_STRING_PREFIX).append(this.type.getTypeName());
        if (!this.namespace.isEmpty()) {
            buffer.append(NAMESPACE).append(this.namespace);
        }
        if (!this.name.isEmpty()) {
            buffer.append(NAME).append(this.name);
        }
        if (this.qualifierType != null) {
            buffer.append(QUALIFIER_TYPE).append(this.qualifierType.getSimpleName());
        }
        buffer.append(']');
    }

    public static <T> Key<T> forClass(Class<T> clazz) {
        return Key.builder(clazz).setQualifierType(Key.getQualifierType(clazz)).setName(Keys.getName(clazz)).setNamespace(Keys.getNamespace(clazz)).setOrder(Key.getOrder(clazz)).get();
    }

    public static <T> Key<T> forMethod(Method method) {
        return Key.builder(method.getGenericReturnType()).setQualifierType(Key.getQualifierType(method)).setName(Keys.getName(method)).setNamespace(Keys.getNamespace(method)).setOrder(Key.getOrder(method)).get();
    }

    public static <T> Key<T> forParameter(Parameter parameter) {
        return Key.builder(parameter.getParameterizedType()).setQualifierType(Key.getQualifierType(parameter)).setName(Keys.getName(parameter)).setNamespace(Keys.getNamespace(parameter)).get();
    }

    public static <T> Key<T> forField(Field field) {
        return Key.builder(field.getGenericType()).setQualifierType(Key.getQualifierType(field)).setName(Keys.getName(field)).setNamespace(Keys.getNamespace(field)).get();
    }

    public static <T> Builder<T> builder(Type type) {
        return new Builder(type);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static <T> Builder<T> builder(Key<T> original) {
        return new Builder<T>(original);
    }

    private static Class<? extends Annotation> getQualifierType(AnnotatedElement element) {
        Annotation qualifierAnnotation = AnnotationUtil.getMetaAnnotation(element, QualifierType.class);
        return qualifierAnnotation != null ? qualifierAnnotation.annotationType() : null;
    }

    private static int getOrder(AnnotatedElement element) {
        Ordered annotation = element.getAnnotation(Ordered.class);
        return annotation != null ? annotation.value() : 0;
    }

    public static final class Builder<T>
    implements Supplier<Key<T>> {
        private final Type type;
        private final Class<T> rawType;
        private Class<? extends Annotation> qualifierType;
        private String name;
        private String namespace;
        private Integer order;

        private Builder(Type type) {
            this.type = type;
            this.rawType = (Class)Cast.cast(TypeUtil.getRawType(type));
        }

        private Builder(Class<T> type) {
            this.type = type;
            this.rawType = type;
        }

        private Builder(Key<T> original) {
            this.type = original.type;
            this.rawType = original.rawType;
            this.qualifierType = original.qualifierType;
            this.name = original.name;
            this.namespace = original.namespace;
            this.order = original.order;
        }

        public Builder<T> setQualifierType(Class<? extends Annotation> qualifierType) {
            this.qualifierType = qualifierType;
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<T> setOrder(int order) {
            this.order = order;
            return this;
        }

        @Override
        public Key<T> get() {
            if (this.name == null) {
                this.name = "";
            }
            if (this.namespace == null) {
                this.namespace = "";
            }
            int order = this.order != null ? this.order : Key.getOrder(this.rawType);
            return new Key<T>(this.type, this.rawType, this.qualifierType, this.name, this.namespace, order);
        }
    }
}

