/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb2;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.nosql.AbstractNoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.mongodb2.MongoDbObject;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.BSON;
import org.bson.Transformer;

public final class MongoDbConnection
extends AbstractNoSqlConnection<BasicDBObject, MongoDbObject> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final DBCollection collection;
    private final WriteConcern writeConcern;

    public MongoDbConnection(DB database, WriteConcern writeConcern, String collectionName, Boolean isCapped, Integer collectionSize) {
        if (database.collectionExists(collectionName)) {
            LOGGER.debug("Gettting collection {}", (Object)collectionName);
            this.collection = database.getCollection(collectionName);
        } else {
            BasicDBObject options = new BasicDBObject();
            options.put("capped", (Object)isCapped);
            options.put("size", (Object)collectionSize);
            LOGGER.debug("Creating collection {} (capped = {}, size = {})", (Object)collectionName, (Object)isCapped, (Object)collectionSize);
            this.collection = database.createCollection(collectionName, (DBObject)options);
        }
        this.writeConcern = writeConcern;
    }

    public void closeImpl() {
        Mongo mongo = this.collection.getDB().getMongo();
        LOGGER.debug("Closing {} client {}", (Object)mongo.getClass().getSimpleName(), (Object)mongo);
        mongo.close();
    }

    public MongoDbObject[] createList(int length) {
        return new MongoDbObject[length];
    }

    public MongoDbObject createObject() {
        return new MongoDbObject();
    }

    public void insertObject(NoSqlObject<BasicDBObject> object) {
        try {
            BasicDBObject unwrapped = (BasicDBObject)object.unwrap();
            LOGGER.debug("Inserting object {}", (Object)unwrapped);
            this.collection.insert((DBObject)unwrapped, this.writeConcern);
        }
        catch (MongoException e) {
            throw new AppenderLoggingException("Failed to write log event to MongoDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        BSON.addEncodingHook(Level.class, (Transformer)new Transformer(){

            public Object transform(Object o) {
                if (o instanceof Level) {
                    return ((Level)o).name();
                }
                return o;
            }
        });
    }
}

