/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public class MessageFormatMessage
implements Message {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String messagePattern;
    private final Object[] parameters;
    private String formattedMessage;
    private Throwable throwable;
    private final Locale locale;

    public MessageFormatMessage(Locale locale, String messagePattern, Object ... parameters) {
        int length;
        this.locale = locale;
        this.messagePattern = messagePattern;
        this.parameters = parameters;
        int n = length = parameters == null ? 0 : parameters.length;
        if (length > 0 && parameters[length - 1] instanceof Throwable) {
            this.throwable = (Throwable)parameters[length - 1];
        }
    }

    public MessageFormatMessage(String messagePattern, Object ... parameters) {
        this(Locale.getDefault(Locale.Category.FORMAT), messagePattern, parameters);
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.parameters);
        }
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    protected String formatMessage(String msgPattern, Object ... args) {
        try {
            MessageFormat temp = new MessageFormat(msgPattern, this.locale);
            return temp.format(args);
        }
        catch (IllegalFormatException ife) {
            LOGGER.error("Unable to format msg: " + msgPattern, (Throwable)ife);
            return msgPattern;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageFormatMessage that = (MessageFormatMessage)o;
        return Objects.equals(this.messagePattern, that.messagePattern) && Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.messagePattern);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

