/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.net.URL;
import java.security.Permission;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ProviderUtil;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static final Logger LOGGER = StatusLogger.getLogger();

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkPermission(permission);
        }
    }

    private void loadProvider(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            this.loadProvider((BundleWiring)bundle.adapt(BundleWiring.class));
        }
        catch (SecurityException e) {
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", bundle.getSymbolicName(), e);
        }
        catch (Exception e) {
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", bundle.getSymbolicName(), e);
        }
    }

    private void loadProvider(BundleWiring provider) {
        List urls = provider.findEntries("META-INF", "log4j-provider.properties", 0);
        for (URL url : urls) {
            ProviderUtil.loadProvider(url, provider.getClassLoader());
        }
    }

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        BundleWiring self = (BundleWiring)context.getBundle().adapt(BundleWiring.class);
        List required = self.getRequiredWires(LoggerContextFactory.class.getName());
        for (BundleWire wire : required) {
            this.loadProvider(wire.getProviderWiring());
        }
        context.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundles = context.getBundles()) {
            this.loadProvider(bundle);
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.loadProvider(event.getBundle());
                break;
            }
        }
    }
}

