/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamFlatTransformValues<KIn, VIn, VOut>
implements ProcessorSupplier<KIn, VIn> {
    private final ValueTransformerWithKeySupplier<KIn, VIn, Iterable<VOut>> valueTransformerSupplier;

    public KStreamFlatTransformValues(ValueTransformerWithKeySupplier<KIn, VIn, Iterable<VOut>> valueTransformerWithKeySupplier) {
        this.valueTransformerSupplier = valueTransformerWithKeySupplier;
    }

    @Override
    public Processor<KIn, VIn> get() {
        return new KStreamFlatTransformValuesProcessor<KIn, VIn, VOut>(this.valueTransformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.valueTransformerSupplier.stores();
    }

    public static class KStreamFlatTransformValuesProcessor<KIn, VIn, VOut>
    extends AbstractProcessor<KIn, VIn> {
        private final ValueTransformerWithKey<KIn, VIn, Iterable<VOut>> valueTransformer;

        KStreamFlatTransformValuesProcessor(ValueTransformerWithKey<KIn, VIn, Iterable<VOut>> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext(context));
        }

        @Override
        public void process(KIn key, VIn value) {
            Iterable<VOut> transformedValues = this.valueTransformer.transform(key, value);
            if (transformedValues != null) {
                for (VOut transformedValue : transformedValues) {
                    this.context.forward(key, transformedValue);
                }
            }
        }

        @Override
        public void close() {
            super.close();
            this.valueTransformer.close();
        }
    }
}

