/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamFlatTransform<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn> {
    private final TransformerSupplier<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformerSupplier;

    public KStreamFlatTransform(TransformerSupplier<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformerSupplier) {
        this.transformerSupplier = transformerSupplier;
    }

    @Override
    public Processor<KIn, VIn> get() {
        return new KStreamFlatTransformProcessor<KIn, VIn, KOut, VOut>(this.transformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.transformerSupplier.stores();
    }

    public static class KStreamFlatTransformProcessor<KIn, VIn, KOut, VOut>
    extends AbstractProcessor<KIn, VIn> {
        private final Transformer<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformer;

        public KStreamFlatTransformProcessor(Transformer<? super KIn, ? super VIn, Iterable<KeyValue<KOut, VOut>>> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.transformer.init(context);
        }

        @Override
        public void process(KIn key, VIn value) {
            Iterable<KeyValue<KOut, VOut>> pairs = this.transformer.transform(key, value);
            if (pairs != null) {
                for (KeyValue<KOut, VOut> pair : pairs) {
                    this.context().forward(pair.key, pair.value);
                }
            }
        }

        @Override
        public void close() {
            this.transformer.close();
        }
    }
}

