/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Comparator;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.rocksdb.RocksIterator;

class RocksDBRangeIterator
extends RocksDbIterator {
    private final Comparator<byte[]> comparator = Bytes.BYTES_LEXICO_COMPARATOR;
    private final byte[] rawToKey;

    RocksDBRangeIterator(String storeName, RocksIterator iter, Set<KeyValueIterator<Bytes, byte[]>> openIterators, Bytes from, Bytes to) {
        super(storeName, iter, openIterators);
        iter.seek(from.get());
        this.rawToKey = to.get();
        if (this.rawToKey == null) {
            throw new NullPointerException("RocksDBRangeIterator: RawToKey is null for key " + to);
        }
    }

    @Override
    public KeyValue<Bytes, byte[]> makeNext() {
        Object next = super.makeNext();
        if (next == null) {
            return (KeyValue)this.allDone();
        }
        if (this.comparator.compare(((Bytes)((KeyValue)next).key).get(), this.rawToKey) <= 0) {
            return next;
        }
        return (KeyValue)this.allDone();
    }
}

