/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;

public class QueryableStoreProvider {
    private final List<StreamThreadStateStoreProvider> storeProviders;
    private final GlobalStateStoreProvider globalStoreProvider;

    public QueryableStoreProvider(List<StreamThreadStateStoreProvider> storeProviders, GlobalStateStoreProvider globalStateStoreProvider) {
        this.storeProviders = new ArrayList<StreamThreadStateStoreProvider>(storeProviders);
        this.globalStoreProvider = globalStateStoreProvider;
    }

    public <T> T getStore(StoreQueryParameters<T> storeQueryParameters) {
        QueryableStoreType<T> queryableStoreType;
        String storeName = storeQueryParameters.storeName();
        List<T> globalStore = this.globalStoreProvider.stores(storeName, queryableStoreType = storeQueryParameters.queryableStoreType());
        if (!globalStore.isEmpty()) {
            return queryableStoreType.create(this.globalStoreProvider, storeName);
        }
        ArrayList allStores = new ArrayList();
        for (StreamThreadStateStoreProvider storeProvider : this.storeProviders) {
            List stores = storeProvider.stores(storeQueryParameters);
            if (stores.isEmpty()) continue;
            allStores.addAll(stores);
            if (storeQueryParameters.partition() == null) continue;
            break;
        }
        if (allStores.isEmpty()) {
            if (storeQueryParameters.partition() != null) {
                throw new InvalidStateStoreException(String.format("The specified partition %d for store %s does not exist.", storeQueryParameters.partition(), storeName));
            }
            throw new InvalidStateStoreException("The state store, " + storeName + ", may have migrated to another instance.");
        }
        return queryableStoreType.create(new WrappingStoreProvider(this.storeProviders, storeQueryParameters), storeName);
    }
}

