/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TransformationChain;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerSourceTaskContext;
import org.apache.kafka.connect.runtime.WorkerTask;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.errors.Stage;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.apache.kafka.connect.storage.CloseableOffsetStorageReader;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.TopicAdmin;
import org.apache.kafka.connect.util.TopicCreation;
import org.apache.kafka.connect.util.TopicCreationGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerSourceTask
extends WorkerTask {
    private static final Logger log = LoggerFactory.getLogger(WorkerSourceTask.class);
    private static final long SEND_FAILED_BACKOFF_MS = 100L;
    private final WorkerConfig workerConfig;
    private final SourceTask task;
    private final ClusterConfigState configState;
    private final Converter keyConverter;
    private final Converter valueConverter;
    private final HeaderConverter headerConverter;
    private final TransformationChain<SourceRecord> transformationChain;
    private final KafkaProducer<byte[], byte[]> producer;
    private final TopicAdmin admin;
    private final CloseableOffsetStorageReader offsetReader;
    private final OffsetStorageWriter offsetWriter;
    private final Executor closeExecutor;
    private final SourceTaskMetricsGroup sourceTaskMetricsGroup;
    private final AtomicReference<Exception> producerSendException;
    private final boolean isTopicTrackingEnabled;
    private final TopicCreation topicCreation;
    private List<SourceRecord> toSend;
    private boolean lastSendFailed;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessages;
    private IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> outstandingMessagesBacklog;
    private boolean flushing;
    private CountDownLatch stopRequestedLatch;
    private Map<String, String> taskConfig;
    private boolean started = false;

    public WorkerSourceTask(ConnectorTaskId id, SourceTask task, TaskStatus.Listener statusListener, TargetState initialState, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, TransformationChain<SourceRecord> transformationChain, KafkaProducer<byte[], byte[]> producer, TopicAdmin admin, Map<String, TopicCreationGroup> topicGroups, CloseableOffsetStorageReader offsetReader, OffsetStorageWriter offsetWriter, WorkerConfig workerConfig, ClusterConfigState configState, ConnectMetrics connectMetrics, ClassLoader loader, Time time, RetryWithToleranceOperator retryWithToleranceOperator, StatusBackingStore statusBackingStore, Executor closeExecutor) {
        super(id, statusListener, initialState, loader, connectMetrics, retryWithToleranceOperator, time, statusBackingStore);
        this.workerConfig = workerConfig;
        this.task = task;
        this.configState = configState;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.headerConverter = headerConverter;
        this.transformationChain = transformationChain;
        this.producer = producer;
        this.admin = admin;
        this.offsetReader = offsetReader;
        this.offsetWriter = offsetWriter;
        this.closeExecutor = closeExecutor;
        this.toSend = null;
        this.lastSendFailed = false;
        this.outstandingMessages = new IdentityHashMap();
        this.outstandingMessagesBacklog = new IdentityHashMap();
        this.flushing = false;
        this.stopRequestedLatch = new CountDownLatch(1);
        this.sourceTaskMetricsGroup = new SourceTaskMetricsGroup(id, connectMetrics);
        this.producerSendException = new AtomicReference();
        this.isTopicTrackingEnabled = workerConfig.getBoolean("topic.tracking.enable");
        this.topicCreation = TopicCreation.newTopicCreation(workerConfig, topicGroups);
    }

    @Override
    public void initialize(TaskConfig taskConfig) {
        try {
            this.taskConfig = taskConfig.originalsStrings();
        }
        catch (Throwable t) {
            log.error("{} Task failed initialization and will not be started.", (Object)this, (Object)t);
            this.onFailure(t);
        }
    }

    @Override
    protected void close() {
        if (this.started) {
            try {
                this.task.stop();
            }
            catch (Throwable t) {
                log.warn("Could not stop task", t);
            }
        }
        this.closeProducer(Duration.ofSeconds(30L));
        if (this.admin != null) {
            try {
                this.admin.close(Duration.ofSeconds(30L));
            }
            catch (Throwable t) {
                log.warn("Failed to close admin client on time", t);
            }
        }
        Utils.closeQuietly(this.transformationChain, (String)"transformation chain");
        Utils.closeQuietly((AutoCloseable)this.retryWithToleranceOperator, (String)"retry operator");
    }

    @Override
    public void removeMetrics() {
        try {
            this.sourceTaskMetricsGroup.close();
        }
        finally {
            super.removeMetrics();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.offsetReader.close();
        this.closeExecutor.execute(() -> this.closeProducer(Duration.ZERO));
    }

    @Override
    public void stop() {
        super.stop();
        this.stopRequestedLatch.countDown();
    }

    @Override
    public void execute() {
        try {
            this.started = true;
            this.task.initialize((SourceTaskContext)new WorkerSourceTaskContext(this.offsetReader, this, this.configState));
            this.task.start(this.taskConfig);
            log.info("{} Source task finished initialization and start", (Object)this);
            while (!this.isStopping()) {
                if (this.shouldPause()) {
                    this.onPause();
                    if (!this.awaitUnpause()) continue;
                    this.onResume();
                    continue;
                }
                this.maybeThrowProducerSendException();
                if (this.toSend == null) {
                    log.trace("{} Nothing to send to Kafka. Polling source for additional records", (Object)this);
                    long start = this.time.milliseconds();
                    this.toSend = this.poll();
                    if (this.toSend != null) {
                        this.recordPollReturned(this.toSend.size(), this.time.milliseconds() - start);
                    }
                }
                if (this.toSend == null) continue;
                log.trace("{} About to send {} records to Kafka", (Object)this, (Object)this.toSend.size());
                if (this.sendRecords()) continue;
                this.stopRequestedLatch.await(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.commitOffsets();
        }
    }

    private void closeProducer(Duration duration) {
        if (this.producer != null) {
            try {
                this.producer.close(duration);
            }
            catch (Throwable t) {
                log.warn("Could not close producer for {}", (Object)this.id, (Object)t);
            }
        }
    }

    private void maybeThrowProducerSendException() {
        if (this.producerSendException.get() != null) {
            throw new ConnectException("Unrecoverable exception from producer send callback", (Throwable)this.producerSendException.get());
        }
    }

    protected List<SourceRecord> poll() throws InterruptedException {
        try {
            return this.task.poll();
        }
        catch (org.apache.kafka.common.errors.RetriableException | RetriableException e) {
            log.warn("{} failed to poll records from SourceTask. Will retry operation.", (Object)this, (Object)e);
            return null;
        }
    }

    private ProducerRecord<byte[], byte[]> convertTransformedRecord(SourceRecord record) {
        if (record == null) {
            return null;
        }
        RecordHeaders headers = (RecordHeaders)this.retryWithToleranceOperator.execute(() -> this.convertHeaderFor(record), Stage.HEADER_CONVERTER, this.headerConverter.getClass());
        byte[] key = (byte[])this.retryWithToleranceOperator.execute(() -> this.keyConverter.fromConnectData(record.topic(), (Headers)headers, record.keySchema(), record.key()), Stage.KEY_CONVERTER, this.keyConverter.getClass());
        byte[] value = (byte[])this.retryWithToleranceOperator.execute(() -> this.valueConverter.fromConnectData(record.topic(), (Headers)headers, record.valueSchema(), record.value()), Stage.VALUE_CONVERTER, this.valueConverter.getClass());
        if (this.retryWithToleranceOperator.failed()) {
            return null;
        }
        return new ProducerRecord(record.topic(), record.kafkaPartition(), ConnectUtils.checkAndConvertTimestamp(record.timestamp()), (Object)key, (Object)value, (Iterable)headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRecords() {
        int processed = 0;
        this.recordBatch(this.toSend.size());
        SourceRecordWriteCounter counter = this.toSend.size() > 0 ? new SourceRecordWriteCounter(this.toSend.size(), this.sourceTaskMetricsGroup) : null;
        for (SourceRecord preTransformRecord : this.toSend) {
            this.maybeThrowProducerSendException();
            this.retryWithToleranceOperator.sourceRecord(preTransformRecord);
            SourceRecord record = this.transformationChain.apply(preTransformRecord);
            ProducerRecord<byte[], byte[]> producerRecord = this.convertTransformedRecord(record);
            if (producerRecord == null || this.retryWithToleranceOperator.failed()) {
                counter.skipRecord();
                this.commitTaskRecord(preTransformRecord, null);
                continue;
            }
            log.trace("{} Appending record with key {}, value {}", new Object[]{this, record.key(), record.value()});
            WorkerSourceTask workerSourceTask = this;
            synchronized (workerSourceTask) {
                if (!this.lastSendFailed) {
                    if (!this.flushing) {
                        this.outstandingMessages.put(producerRecord, producerRecord);
                    } else {
                        this.outstandingMessagesBacklog.put(producerRecord, producerRecord);
                    }
                    this.offsetWriter.offset(record.sourcePartition(), record.sourceOffset());
                }
            }
            try {
                this.maybeCreateTopic(record.topic());
                String topic = producerRecord.topic();
                this.producer.send(producerRecord, (recordMetadata, e) -> {
                    if (e != null) {
                        log.error("{} failed to send record to {}: ", new Object[]{this, topic, e});
                        log.debug("{} Failed record: {}", (Object)this, (Object)preTransformRecord);
                        this.producerSendException.compareAndSet(null, e);
                    } else {
                        this.recordSent(producerRecord);
                        counter.completeRecord();
                        log.trace("{} Wrote record successfully: topic {} partition {} offset {}", new Object[]{this, recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                        this.commitTaskRecord(preTransformRecord, recordMetadata);
                        if (this.isTopicTrackingEnabled) {
                            this.recordActiveTopic(producerRecord.topic());
                        }
                    }
                });
                this.lastSendFailed = false;
            }
            catch (org.apache.kafka.common.errors.RetriableException | RetriableException e2) {
                log.warn("{} Failed to send record to topic '{}' and partition '{}'. Backing off before retrying: ", new Object[]{this, producerRecord.topic(), producerRecord.partition(), e2});
                this.toSend = this.toSend.subList(processed, this.toSend.size());
                this.lastSendFailed = true;
                counter.retryRemaining();
                return false;
            }
            catch (ConnectException e3) {
                log.warn("{} Failed to send record to topic '{}' and partition '{}' due to an unrecoverable exception: ", new Object[]{this, producerRecord.topic(), producerRecord.partition(), e3});
                log.warn("{} Failed to send {} with unrecoverable exception: ", new Object[]{this, producerRecord, e3});
                throw e3;
            }
            catch (KafkaException e4) {
                throw new ConnectException("Unrecoverable exception trying to send", (Throwable)e4);
            }
            ++processed;
        }
        this.toSend = null;
        return true;
    }

    private void maybeCreateTopic(String topic) {
        if (!this.topicCreation.isTopicCreationRequired(topic)) {
            return;
        }
        log.info("The task will send records to topic '{}' for the first time. Checking whether topic exists", (Object)topic);
        Map<String, TopicDescription> existing = this.admin.describeTopics(topic);
        if (!existing.isEmpty()) {
            log.info("Topic '{}' already exists.", (Object)topic);
            this.topicCreation.addTopic(topic);
            return;
        }
        log.info("Creating topic '{}'", (Object)topic);
        TopicCreationGroup topicGroup = this.topicCreation.findFirstGroup(topic);
        log.debug("Topic '{}' matched topic creation group: {}", (Object)topic, (Object)topicGroup);
        NewTopic newTopic = topicGroup.newTopic(topic);
        TopicAdmin.TopicCreationResponse response = this.admin.createOrFindTopics(newTopic);
        if (response.isCreated(newTopic.name())) {
            this.topicCreation.addTopic(topic);
            log.info("Created topic '{}' using creation group {}", (Object)newTopic, (Object)topicGroup);
        } else if (response.isExisting(newTopic.name())) {
            this.topicCreation.addTopic(topic);
            log.info("Found existing topic '{}'", (Object)newTopic);
        } else {
            log.warn("Request to create new topic '{}' failed", (Object)topic);
            throw new ConnectException("Task failed to create new topic " + topic + ". Ensure that the task is authorized to create topics or that the topic exists and restart the task");
        }
    }

    private RecordHeaders convertHeaderFor(SourceRecord record) {
        org.apache.kafka.connect.header.Headers headers = record.headers();
        RecordHeaders result = new RecordHeaders();
        if (headers != null) {
            String topic = record.topic();
            for (Header header : headers) {
                String key = header.key();
                byte[] rawHeader = this.headerConverter.fromConnectHeader(topic, key, header.schema(), header.value());
                result.add(key, rawHeader);
            }
        }
        return result;
    }

    private void commitTaskRecord(SourceRecord record, RecordMetadata metadata) {
        try {
            this.task.commitRecord(record, metadata);
        }
        catch (Throwable t) {
            log.error("{} Exception thrown while calling task.commitRecord()", (Object)this, (Object)t);
        }
    }

    private synchronized void recordSent(ProducerRecord<byte[], byte[]> record) {
        ProducerRecord<byte[], byte[]> removed = this.outstandingMessages.remove(record);
        if (removed == null && this.flushing) {
            removed = this.outstandingMessagesBacklog.remove(record);
        }
        if (removed == null) {
            log.error("{} CRITICAL Saw callback for record that was not present in the outstanding message set: {}", (Object)this, record);
        } else if (this.flushing && this.outstandingMessages.isEmpty()) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitOffsets() {
        long commitTimeoutMs = this.workerConfig.getLong("offset.flush.timeout.ms");
        log.info("{} Committing offsets", (Object)this);
        long started = this.time.milliseconds();
        long timeout = started + commitTimeoutMs;
        WorkerSourceTask workerSourceTask = this;
        synchronized (workerSourceTask) {
            this.flushing = true;
            boolean flushStarted = this.offsetWriter.beginFlush();
            log.info("{} flushing {} outstanding messages for offset commit", (Object)this, (Object)this.outstandingMessages.size());
            while (!this.outstandingMessages.isEmpty()) {
                try {
                    long timeoutMs = timeout - this.time.milliseconds();
                    if (this.isCancelled() || timeoutMs <= 0L) {
                        log.error("{} Failed to flush, timed out while waiting for producer to flush outstanding {} messages", (Object)this, (Object)this.outstandingMessages.size());
                        this.finishFailedFlush();
                        this.recordCommitFailure(this.time.milliseconds() - started, null);
                        return false;
                    }
                    this.wait(timeoutMs);
                }
                catch (InterruptedException e) {
                    log.error("{} Interrupted while flushing messages, offsets will not be committed", (Object)this);
                    this.finishFailedFlush();
                    this.recordCommitFailure(this.time.milliseconds() - started, null);
                    return false;
                }
            }
            if (!flushStarted) {
                this.finishSuccessfulFlush();
                long durationMillis = this.time.milliseconds() - started;
                this.recordCommitSuccess(durationMillis);
                log.debug("{} Finished offset commitOffsets successfully in {} ms", (Object)this, (Object)durationMillis);
                this.commitSourceTask();
                return true;
            }
        }
        Future<Void> flushFuture = this.offsetWriter.doFlush((error, result) -> {
            if (error != null) {
                log.error("{} Failed to flush offsets to storage: ", (Object)this, (Object)error);
            } else {
                log.trace("{} Finished flushing offsets to storage", (Object)this);
            }
        });
        if (flushFuture == null) {
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, null);
            return false;
        }
        try {
            flushFuture.get(Math.max(timeout - this.time.milliseconds(), 0L), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("{} Flush of offsets interrupted, cancelling", (Object)this);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, e);
            return false;
        }
        catch (ExecutionException e) {
            log.error("{} Flush of offsets threw an unexpected exception: ", (Object)this, (Object)e);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, e);
            return false;
        }
        catch (TimeoutException e) {
            log.error("{} Timed out waiting to flush offsets to storage", (Object)this);
            this.finishFailedFlush();
            this.recordCommitFailure(this.time.milliseconds() - started, null);
            return false;
        }
        this.finishSuccessfulFlush();
        long durationMillis = this.time.milliseconds() - started;
        this.recordCommitSuccess(durationMillis);
        log.info("{} Finished commitOffsets successfully in {} ms", (Object)this, (Object)durationMillis);
        this.commitSourceTask();
        return true;
    }

    private void commitSourceTask() {
        try {
            this.task.commit();
        }
        catch (Throwable t) {
            log.error("{} Exception thrown while calling task.commit()", (Object)this, (Object)t);
        }
    }

    private synchronized void finishFailedFlush() {
        this.offsetWriter.cancelFlush();
        this.outstandingMessages.putAll(this.outstandingMessagesBacklog);
        this.outstandingMessagesBacklog.clear();
        this.flushing = false;
    }

    private synchronized void finishSuccessfulFlush() {
        IdentityHashMap<ProducerRecord<byte[], byte[]>, ProducerRecord<byte[], byte[]>> temp = this.outstandingMessages;
        this.outstandingMessages = this.outstandingMessagesBacklog;
        this.outstandingMessagesBacklog = temp;
        this.flushing = false;
    }

    public String toString() {
        return "WorkerSourceTask{id=" + this.id + '}';
    }

    protected void recordPollReturned(int numRecordsInBatch, long duration) {
        this.sourceTaskMetricsGroup.recordPoll(numRecordsInBatch, duration);
    }

    SourceTaskMetricsGroup sourceTaskMetricsGroup() {
        return this.sourceTaskMetricsGroup;
    }

    static class SourceTaskMetricsGroup {
        private final ConnectMetrics.MetricGroup metricGroup;
        private final Sensor sourceRecordPoll;
        private final Sensor sourceRecordWrite;
        private final Sensor sourceRecordActiveCount;
        private final Sensor pollTime;
        private int activeRecordCount;

        public SourceTaskMetricsGroup(ConnectorTaskId id, ConnectMetrics connectMetrics) {
            ConnectMetricsRegistry registry = connectMetrics.registry();
            this.metricGroup = connectMetrics.group(registry.sourceTaskGroupName(), registry.connectorTagName(), id.connector(), registry.taskTagName(), Integer.toString(id.task()));
            this.metricGroup.close();
            this.sourceRecordPoll = this.metricGroup.sensor("source-record-poll");
            this.sourceRecordPoll.add(this.metricGroup.metricName(registry.sourceRecordPollRate), (MeasurableStat)new Rate());
            this.sourceRecordPoll.add(this.metricGroup.metricName(registry.sourceRecordPollTotal), (MeasurableStat)new CumulativeSum());
            this.sourceRecordWrite = this.metricGroup.sensor("source-record-write");
            this.sourceRecordWrite.add(this.metricGroup.metricName(registry.sourceRecordWriteRate), (MeasurableStat)new Rate());
            this.sourceRecordWrite.add(this.metricGroup.metricName(registry.sourceRecordWriteTotal), (MeasurableStat)new CumulativeSum());
            this.pollTime = this.metricGroup.sensor("poll-batch-time");
            this.pollTime.add(this.metricGroup.metricName(registry.sourceRecordPollBatchTimeMax), (MeasurableStat)new Max());
            this.pollTime.add(this.metricGroup.metricName(registry.sourceRecordPollBatchTimeAvg), (MeasurableStat)new Avg());
            this.sourceRecordActiveCount = this.metricGroup.sensor("source-record-active-count");
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCount), (MeasurableStat)new Value());
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCountMax), (MeasurableStat)new Max());
            this.sourceRecordActiveCount.add(this.metricGroup.metricName(registry.sourceRecordActiveCountAvg), (MeasurableStat)new Avg());
        }

        void close() {
            this.metricGroup.close();
        }

        void recordPoll(int batchSize, long duration) {
            this.sourceRecordPoll.record((double)batchSize);
            this.pollTime.record((double)duration);
            this.activeRecordCount += batchSize;
            this.sourceRecordActiveCount.record((double)this.activeRecordCount);
        }

        void recordWrite(int recordCount) {
            this.sourceRecordWrite.record((double)recordCount);
            this.activeRecordCount -= recordCount;
            this.activeRecordCount = Math.max(0, this.activeRecordCount);
            this.sourceRecordActiveCount.record((double)this.activeRecordCount);
        }

        protected ConnectMetrics.MetricGroup metricGroup() {
            return this.metricGroup;
        }
    }

    static class SourceRecordWriteCounter {
        private final SourceTaskMetricsGroup metricsGroup;
        private final int batchSize;
        private boolean completed = false;
        private int counter;

        public SourceRecordWriteCounter(int batchSize, SourceTaskMetricsGroup metricsGroup) {
            assert (batchSize > 0);
            assert (metricsGroup != null);
            this.batchSize = batchSize;
            this.counter = batchSize;
            this.metricsGroup = metricsGroup;
        }

        public void skipRecord() {
            if (this.counter > 0 && --this.counter == 0) {
                this.finishedAllWrites();
            }
        }

        public void completeRecord() {
            if (this.counter > 0 && --this.counter == 0) {
                this.finishedAllWrites();
            }
        }

        public void retryRemaining() {
            this.finishedAllWrites();
        }

        private void finishedAllWrites() {
            if (!this.completed) {
                this.metricsGroup.recordWrite(this.batchSize - this.counter);
                this.completed = true;
            }
        }
    }
}

