/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.Arrays;
import java.util.Locale;

public enum ConnectProtocolCompatibility {
    EAGER{

        @Override
        public String protocol() {
            return "default";
        }
    }
    ,
    COMPATIBLE{

        @Override
        public String protocol() {
            return "compatible";
        }
    };


    public static ConnectProtocolCompatibility compatibility(String name) {
        return Arrays.stream(ConnectProtocolCompatibility.values()).filter(mode -> mode.name().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown Connect protocol compatibility mode: " + name));
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public abstract String protocol();

    public static ConnectProtocolCompatibility fromProtocol(String protocolName) {
        return Arrays.stream(ConnectProtocolCompatibility.values()).filter(mode -> mode.protocol().equalsIgnoreCase(protocolName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not found Connect protocol compatibility mode for protocol: " + protocolName));
    }
}

