/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigTransformerResult;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderRequest;
import org.apache.kafka.connect.runtime.Worker;

public class WorkerConfigTransformer {
    private final Worker worker;
    private final ConfigTransformer configTransformer;
    private final ConcurrentMap<String, Map<String, HerderRequest>> requests = new ConcurrentHashMap<String, Map<String, HerderRequest>>();

    public WorkerConfigTransformer(Worker worker, Map<String, ConfigProvider> configProviders) {
        this.worker = worker;
        this.configTransformer = new ConfigTransformer(configProviders);
    }

    public Map<String, String> transform(Map<String, String> configs) {
        return this.transform(null, configs);
    }

    public Map<String, String> transform(String connectorName, Map<String, String> configs) {
        if (configs == null) {
            return null;
        }
        ConfigTransformerResult result = this.configTransformer.transform(configs);
        if (connectorName != null) {
            this.scheduleReload(connectorName, result.ttls());
        }
        return result.data();
    }

    private void scheduleReload(String connectorName, Map<String, Long> ttls) {
        for (Map.Entry<String, Long> entry : ttls.entrySet()) {
            this.scheduleReload(connectorName, entry.getKey(), entry.getValue());
        }
    }

    private void scheduleReload(String connectorName, String path, long ttl) {
        Herder herder = this.worker.herder();
        if (herder.connectorConfigReloadAction(connectorName) == Herder.ConfigReloadAction.RESTART) {
            ConcurrentHashMap<String, HerderRequest> connectorRequests = (ConcurrentHashMap<String, HerderRequest>)this.requests.get(connectorName);
            if (connectorRequests == null) {
                connectorRequests = new ConcurrentHashMap<String, HerderRequest>();
                this.requests.put(connectorName, connectorRequests);
            } else {
                HerderRequest previousRequest = (HerderRequest)connectorRequests.get(path);
                if (previousRequest != null) {
                    previousRequest.cancel();
                }
            }
            HerderRequest request = herder.restartConnector(ttl, connectorName, null);
            connectorRequests.put(path, request);
        }
    }
}

