/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonDeduplicateObjects;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.JohnzonIgnoreNested;
import org.apache.johnzon.mapper.JohnzonVirtualObject;
import org.apache.johnzon.mapper.JohnzonVirtualObjects;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.converter.DateWithCopyConverter;
import org.apache.johnzon.mapper.converter.EnumConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;
import org.apache.johnzon.mapper.reflection.Generics;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class Mappings {
    private static final JohnzonParameterizedType VIRTUAL_TYPE = new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class});
    protected final ConcurrentMap<Type, ClassMapping> classes = new ConcurrentHashMap<Type, ClassMapping>();
    protected final ConcurrentMap<Type, CollectionMapping> collections = new ConcurrentHashMap<Type, CollectionMapping>();
    protected final MapperConfig config;

    public Mappings(MapperConfig config) {
        this.config = config;
    }

    public CollectionMapping findCollectionMapping(ParameterizedType genericType, Type enclosingType) {
        CollectionMapping collectionMapping = (CollectionMapping)this.collections.get(genericType);
        if (collectionMapping == null) {
            collectionMapping = this.createCollectionMapping(genericType, enclosingType);
            if (collectionMapping == null) {
                return null;
            }
            CollectionMapping existing = this.collections.putIfAbsent(genericType, collectionMapping);
            if (existing != null) {
                collectionMapping = existing;
            }
        }
        return collectionMapping;
    }

    private <T> CollectionMapping createCollectionMapping(ParameterizedType aType, Type root) {
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        Type raw = aType.getRawType();
        if (fieldArgTypes.length == 1 && Class.class.isInstance(raw)) {
            Class collectionType;
            Class r = (Class)Class.class.cast(raw);
            if (PriorityQueue.class.isAssignableFrom(r)) {
                collectionType = PriorityQueue.class;
            } else if (LinkedHashSet.class.isAssignableFrom(r)) {
                collectionType = LinkedHashSet.class;
            } else if (LinkedList.class.isAssignableFrom(r)) {
                collectionType = LinkedList.class;
            } else if (TreeSet.class.isAssignableFrom(r)) {
                collectionType = TreeSet.class;
            } else if (List.class.isAssignableFrom(r)) {
                collectionType = List.class;
            } else if (SortedSet.class.isAssignableFrom(r)) {
                collectionType = SortedSet.class;
            } else if (EnumSet.class.isAssignableFrom(r)) {
                collectionType = EnumSet.class;
            } else if (Set.class.isAssignableFrom(r)) {
                collectionType = Set.class;
            } else if (Deque.class.isAssignableFrom(r)) {
                collectionType = Deque.class;
            } else if (Queue.class.isAssignableFrom(r)) {
                collectionType = Queue.class;
            } else if (Collection.class.isAssignableFrom(r)) {
                collectionType = Collection.class;
            } else {
                return null;
            }
            CollectionMapping mapping = new CollectionMapping(Mappings.isPrimitive(fieldArgTypes[0]), collectionType, Generics.resolve(fieldArgTypes[0], root));
            this.collections.putIfAbsent(aType, mapping);
            return mapping;
        }
        return null;
    }

    public static boolean isPrimitive(Type type) {
        if (type == String.class) {
            return true;
        }
        if (type == Character.TYPE || type == Character.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    public static Object getPrimitiveDefault(Type type) {
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public ClassMapping getClassMapping(Type clazz) {
        return (ClassMapping)this.classes.get(clazz);
    }

    public ClassMapping findOrCreateClassMapping(Type clazz) {
        return this.doFindOrCreateClassMapping(clazz, Collections.emptyMap());
    }

    private ClassMapping doFindOrCreateClassMapping(Type clazz, Map<Type, Type> args) {
        ClassMapping classMapping = (ClassMapping)this.classes.get(clazz);
        if (classMapping == null) {
            if (ParameterizedType.class.isInstance(clazz)) {
                ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(clazz);
                ClassMapping mapping = this.doFindOrCreateClassMapping(pt.getRawType(), Generics.toResolvedTypes(pt));
                return this.putOrGetClassMapping(clazz, mapping);
            }
            if (!Class.class.isInstance(clazz)) {
                return null;
            }
            Class asClass = (Class)Class.class.cast(clazz);
            if (Map.class.isAssignableFrom(asClass) || asClass.isInterface()) {
                Class<?> mapping = this.config.getInterfaceImplementationMapping().get(clazz);
                if (mapping != null) {
                    classMapping = this.createClassMapping(mapping, args);
                } else {
                    if (asClass.getName().startsWith("java.")) {
                        return null;
                    }
                    classMapping = this.createClassMapping(asClass, args);
                }
            } else {
                classMapping = this.createClassMapping(asClass, args);
            }
            classMapping = this.putOrGetClassMapping(clazz, classMapping);
        }
        return classMapping;
    }

    private ClassMapping putOrGetClassMapping(Type clazz, ClassMapping classMapping) {
        if (classMapping == null) {
            return null;
        }
        ClassMapping existing = this.classes.putIfAbsent(clazz, classMapping);
        if (existing != null) {
            return existing;
        }
        return classMapping;
    }

    protected ClassMapping createClassMapping(Class<?> inClazz, Map<Type, Type> resolvedTypes) {
        JohnzonVirtualObject johnzonVirtualObject;
        boolean copyDate = false;
        for (Class<?> itf : inClazz.getInterfaces()) {
            if (!"org.apache.openjpa.enhance.PersistenceCapable".equals(itf.getName())) continue;
            copyDate = true;
            break;
        }
        Class<?> clazz = this.findModelClass(inClazz);
        AccessMode accessMode = this.config.getAccessMode();
        Comparator<String> fieldComparator = accessMode.fieldComparator(inClazz);
        fieldComparator = fieldComparator == null ? this.config.getAttributeOrder() : fieldComparator;
        TreeMap<String, Getter> getters = fieldComparator == null ? this.newOrderedMap(Getter.class) : new TreeMap(fieldComparator);
        TreeMap<String, Setter> setters = fieldComparator == null ? this.newOrderedMap(Setter.class) : new TreeMap(fieldComparator);
        Map<String, AccessMode.Reader> readers = accessMode.findReaders(clazz);
        Map<String, AccessMode.Writer> writers = accessMode.findWriters(clazz);
        HashSet<String> virtualFields = new HashSet<String>();
        JohnzonVirtualObjects virtualObjects = clazz.getAnnotation(JohnzonVirtualObjects.class);
        if (virtualObjects != null) {
            for (JohnzonVirtualObject virtualObject2 : virtualObjects.value()) {
                this.handleVirtualObject(virtualFields, virtualObject2, getters, setters, readers, writers, copyDate, clazz);
            }
        }
        if ((johnzonVirtualObject = clazz.getAnnotation(JohnzonVirtualObject.class)) != null) {
            this.handleVirtualObject(virtualFields, johnzonVirtualObject, getters, setters, readers, writers, copyDate, clazz);
        }
        for (Map.Entry entry : readers.entrySet()) {
            String key = (String)entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addGetterIfNeeded(getters, key, (AccessMode.Reader)entry.getValue(), copyDate, resolvedTypes);
        }
        for (Map.Entry<String, AccessMode.Writer> entry : writers.entrySet()) {
            String key = entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addSetterIfNeeded(setters, key, entry.getValue(), copyDate, clazz, resolvedTypes);
        }
        Method anyGetter = accessMode.findAnyGetter(clazz);
        ClassMapping classMapping = new ClassMapping(clazz, accessMode.findFactory(clazz), getters, setters, accessMode.findAdapter(clazz), accessMode.findReader(clazz), accessMode.findWriter(clazz), anyGetter != null ? new Getter(new MethodAccessMode.MethodReader(anyGetter, anyGetter.getReturnType()), false, false, false, false, true, null, null, -1, null) : null, accessMode.findAnySetter(clazz), Map.class.isAssignableFrom(clazz) ? accessMode.findMapAdder(clazz) : null);
        accessMode.afterParsed(clazz);
        return classMapping;
    }

    protected Class<?> findModelClass(Class<?> inClazz) {
        Class<?> clazz;
        for (clazz = inClazz; clazz != null && clazz != Object.class && (clazz.getName().contains("$$") || clazz.getName().contains("$proxy") || clazz.getName().startsWith("org.apache.openjpa.enhance.")); clazz = clazz.getSuperclass()) {
        }
        if (clazz == null || clazz == Object.class) {
            clazz = inClazz;
        }
        return clazz;
    }

    private <T> Map<String, T> newOrderedMap(Class<T> value) {
        return this.config.getAttributeOrder() != null ? new TreeMap(this.config.getAttributeOrder()) : new HashMap();
    }

    private void addSetterIfNeeded(Map<String, Setter> setters, String key, AccessMode.Writer value, boolean copyDate, Class<?> rootClass, Map<Type, Type> resolvedTypes) {
        JohnzonIgnore writeIgnore = value.getAnnotation(JohnzonIgnore.class);
        if (writeIgnore == null || writeIgnore.minVersion() >= 0) {
            if (key.equals("metaClass")) {
                return;
            }
            Type param = this.lookupType(value, resolvedTypes);
            Class returnType = Class.class.isInstance(param) ? (Class)Class.class.cast(param) : null;
            Setter setter = new Setter(value, Mappings.isPrimitive(param), returnType != null && returnType.isArray() || GenericArrayType.class.isInstance(value.getType()), Generics.resolve(param, rootClass), this.findConverter(copyDate, value), value.findObjectConverterReader(), writeIgnore != null ? writeIgnore.minVersion() : -1);
            setters.put(key, setter);
        }
    }

    private Type lookupType(AccessMode.DecoratedType value, Map<Type, Type> resolvedTypes) {
        return resolvedTypes.getOrDefault(value.getType(), value.getType());
    }

    private void addGetterIfNeeded(Map<String, Getter> getters, String key, AccessMode.Reader value, boolean copyDate, Map<Type, Type> resolvedTypes) {
        JohnzonIgnore readIgnore = value.getAnnotation(JohnzonIgnore.class);
        JohnzonIgnoreNested ignoreNested = value.getAnnotation(JohnzonIgnoreNested.class);
        if (readIgnore == null || readIgnore.minVersion() >= 0) {
            Type type = this.lookupType(value, resolvedTypes);
            Class returnType = Class.class.isInstance(type) ? (Class)Class.class.cast(type) : null;
            ParameterizedType pt = ParameterizedType.class.isInstance(type) ? (ParameterizedType)ParameterizedType.class.cast(type) : null;
            Getter getter = new Getter(value, returnType == Object.class, Mappings.isPrimitive(returnType), returnType != null && returnType.isArray() || GenericArrayType.class.isInstance(type), pt != null && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Collection.class.isAssignableFrom(returnType), pt != null && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Map.class.isAssignableFrom(returnType), this.findConverter(copyDate, value), value.findObjectConverterWriter(), readIgnore != null ? readIgnore.minVersion() : -1, ignoreNested != null ? ignoreNested.properties() : null);
            getters.put(key, getter);
        }
    }

    private void handleVirtualObject(Collection<String> virtualFields, JohnzonVirtualObject o, Map<String, Getter> getters, Map<String, Setter> setters, Map<String, AccessMode.Reader> readers, Map<String, AccessMode.Writer> writers, boolean copyDate, Class<?> rootClazz) {
        String[] path = o.path();
        if (path.length < 1) {
            throw new IllegalArgumentException("@JohnzonVirtualObject need a path");
        }
        for (JohnzonVirtualObject.Field f : o.fields()) {
            virtualFields.add(f.value());
        }
        Map<String, Getter> objectGetters = this.newOrderedMap(Getter.class);
        Map<String, Setter> objectSetters = this.newOrderedMap(Setter.class);
        for (JohnzonVirtualObject.Field f : o.fields()) {
            AccessMode.Writer writer;
            AccessMode.Reader reader;
            String name = f.value();
            if (f.read() && (reader = readers.get(name)) != null) {
                this.addGetterIfNeeded(objectGetters, name, reader, copyDate, Collections.emptyMap());
            }
            if (!f.write() || (writer = writers.get(name)) == null) continue;
            this.addSetterIfNeeded(objectSetters, name, writer, copyDate, rootClazz, Collections.emptyMap());
        }
        String key = path[0];
        Getter getter = getters.get(key);
        MapBuilderReader newReader = new MapBuilderReader(objectGetters, path, this.config.getVersion());
        getters.put(key, new Getter(getter == null ? newReader : new CompositeReader(getter.reader, newReader), false, false, false, false, true, null, null, -1, null));
        Setter newSetter = setters.get(key);
        MapUnwrapperWriter newWriter = new MapUnwrapperWriter(objectSetters, path);
        setters.put(key, new Setter(newSetter == null ? newWriter : new CompositeWriter(newSetter.writer, newWriter), false, false, VIRTUAL_TYPE, null, null, -1));
    }

    private MapperConverter findConverter(boolean copyDate, AccessMode.DecoratedType decoratedType) {
        Type type;
        Type rawType;
        MapperConverter converter = decoratedType.findConverter();
        if (converter != null) {
            return converter;
        }
        JohnzonConverter annotation = decoratedType.getAnnotation(JohnzonConverter.class);
        Type typeToTest = decoratedType.getType();
        if (annotation != null) {
            try {
                converter = annotation.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (ParameterizedType.class.isInstance(decoratedType.getType()) && Class.class.isInstance(rawType = (type = (ParameterizedType)ParameterizedType.class.cast(decoratedType.getType())).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType)) && type.getActualTypeArguments().length >= 1) {
            typeToTest = type.getActualTypeArguments()[0];
        }
        if (converter == null && Class.class.isInstance(typeToTest)) {
            AdapterKey key;
            type = (Class)Class.class.cast(typeToTest);
            ConcurrentMap<AdapterKey, Adapter<?, ?>> adapters = this.config.getAdapters();
            if (Date.class.isAssignableFrom((Class<?>)type) && copyDate) {
                converter = new DateWithCopyConverter((Adapter)Adapter.class.cast(adapters.get(new AdapterKey((Type)((Object)Date.class), (Type)((Object)String.class)))));
            } else {
                for (Map.Entry adapterEntry : adapters.entrySet()) {
                    if (((AdapterKey)adapterEntry.getKey()).getFrom() == ((AdapterKey)adapterEntry.getKey()).getTo() || ((AdapterKey)adapterEntry.getKey()).getFrom() != type || ConverterAdapter.class.isInstance(adapterEntry.getValue()) && ((ConverterAdapter)ConverterAdapter.class.cast(adapterEntry.getValue())).getConverter().getClass().getName().startsWith("org.apache.johnzon.mapper.")) continue;
                    if (converter != null) {
                        throw new IllegalArgumentException("Ambiguous adapter for " + decoratedType);
                    }
                    converter = (MapperConverter)adapterEntry.getValue();
                }
            }
            if (converter == null && Enum.class.isAssignableFrom((Class<?>)type) && (converter = (MapperConverter)adapters.get(key = new AdapterKey((Type)((Object)String.class), type))) == null) {
                converter = new ConverterAdapter(new EnumConverter(type));
                adapters.put(key, (Adapter<?, ?>)converter);
            }
        }
        return converter;
    }

    private static class CompositeWriter
    implements AccessMode.Writer {
        private final AccessMode.Writer[] delegates;

        public CompositeWriter(AccessMode.Writer ... writers) {
            LinkedList<AccessMode.Writer> all = new LinkedList<AccessMode.Writer>();
            for (AccessMode.Writer r : writers) {
                if (CompositeWriter.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeWriter)CompositeWriter.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Writer[all.size()]);
        }

        @Override
        public void write(Object instance, Object value) {
            for (AccessMode.Writer w : this.delegates) {
                w.write(instance, value);
            }
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            for (AccessMode.Writer w : this.delegates) {
                ObjectConverter.Reader<?> objectConverter = w.findObjectConverterReader();
                if (objectConverter == null) continue;
                return objectConverter;
            }
            return null;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            for (AccessMode.Writer r : this.delegates) {
                Adapter<?, ?> converter = r.findConverter();
                if (converter == null) continue;
                return converter;
            }
            return null;
        }

        @Override
        public boolean isNillable(boolean global) {
            for (AccessMode.Writer r : this.delegates) {
                if (!r.isNillable(global)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CompositeReader
    implements AccessMode.Reader {
        private final AccessMode.Reader[] delegates;

        public CompositeReader(AccessMode.Reader ... delegates) {
            LinkedList<AccessMode.Reader> all = new LinkedList<AccessMode.Reader>();
            for (AccessMode.Reader r : delegates) {
                if (CompositeReader.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeReader)CompositeReader.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Reader[all.size()]);
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap map = new LinkedHashMap();
            for (AccessMode.Reader reader : this.delegates) {
                Map readerMap = (Map)reader.read(instance);
                for (Map.Entry entry : readerMap.entrySet()) {
                    Object o = map.get(entry.getKey());
                    if (o == null) {
                        map.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (Map.class.isInstance(o)) continue;
                    throw new IllegalStateException((String)entry.getKey() + " is ambiguous");
                }
            }
            return map;
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            for (AccessMode.Reader w : this.delegates) {
                ObjectConverter.Writer<?> objectConverter = w.findObjectConverterWriter();
                if (objectConverter == null) continue;
                return objectConverter;
            }
            return null;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            for (AccessMode.Reader r : this.delegates) {
                Adapter<?, ?> converter = r.findConverter();
                if (converter == null) continue;
                return converter;
            }
            return null;
        }

        @Override
        public boolean isNillable(boolean global) {
            for (AccessMode.Reader r : this.delegates) {
                if (!r.isNillable(global)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MapUnwrapperWriter
    implements AccessMode.Writer {
        private final Map<String, Setter> writers;
        private final Map<String, Class<?>> componentTypes;
        private final String[] paths;

        public MapUnwrapperWriter(Map<String, Setter> writers, String[] paths) {
            this.writers = writers;
            this.paths = paths;
            this.componentTypes = new HashMap();
            for (Map.Entry<String, Setter> setter : writers.entrySet()) {
                if (!setter.getValue().array) continue;
                this.componentTypes.put(setter.getKey(), Class.class.isInstance(setter.getValue().paramType) ? ((Class)Class.class.cast(setter.getValue().paramType)).getComponentType() : this.cast(((GenericArrayType)GenericArrayType.class.cast(setter.getValue().paramType)).getGenericComponentType()));
            }
        }

        private Class<?> cast(Type genericComponentType) {
            if (Class.class.isInstance(genericComponentType)) {
                return (Class)Class.class.cast(genericComponentType);
            }
            if (ParameterizedType.class.isInstance(genericComponentType)) {
                return this.cast(((ParameterizedType)ParameterizedType.class.cast(genericComponentType)).getRawType());
            }
            throw new UnsupportedOperationException("Unsupported type: " + genericComponentType);
        }

        @Override
        public void write(Object instance, Object value) {
            Map nested = null;
            for (String path : this.paths) {
                if ((nested = (Map)Map.class.cast(nested == null ? value : nested.get(path))) != null) continue;
                return;
            }
            for (Map.Entry entry : this.writers.entrySet()) {
                Setter setterValue = (Setter)entry.getValue();
                String key = (String)entry.getKey();
                Object rawValue = nested.get(key);
                Object val = value == null || setterValue.converter == null ? rawValue : ((Converter)Converter.class.cast(setterValue.converter)).toString(rawValue);
                if (val == null) continue;
                if (setterValue.array && Collection.class.isInstance(val)) {
                    Collection collection = (Collection)Collection.class.cast(val);
                    Object[] array = (Object[])Array.newInstance(this.componentTypes.get(key), collection.size());
                    val = collection.toArray(array);
                }
                AccessMode.Writer setterMethod = setterValue.writer;
                setterMethod.write(instance, val);
            }
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            return null;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable(boolean globalConfig) {
            return globalConfig;
        }
    }

    private static class MapBuilderReader
    implements AccessMode.Reader {
        private final Map<String, Getter> getters;
        private final Map<String, Object> template;
        private final String[] paths;
        private final int version;

        public MapBuilderReader(Map<String, Getter> objectGetters, String[] paths, int version) {
            this.getters = objectGetters;
            this.paths = paths;
            this.template = new LinkedHashMap<String, Object>();
            this.version = version;
            Map<String, Object> last = this.template;
            for (int i = 1; i < paths.length; ++i) {
                LinkedHashMap<String, Object> newLast = new LinkedHashMap<String, Object>();
                last.put(paths[i], newLast);
                last = newLast;
            }
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.template);
            Map<String, Object> nested = map;
            for (int i = 1; i < this.paths.length; ++i) {
                nested = (Map)Map.class.cast(nested.get(this.paths[i]));
            }
            for (Map.Entry<String, Getter> g : this.getters.entrySet()) {
                Getter getter = g.getValue();
                Object value = getter.reader.read(instance);
                Object val = value == null || getter.converter == null ? value : getter.converter.from(value);
                if (val == null || getter.version >= 0 && this.version >= getter.version) continue;
                nested.put(g.getKey(), val);
            }
            return map;
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            return null;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable(boolean globalConfig) {
            return globalConfig;
        }
    }

    public static class Setter {
        public final AccessMode.Writer writer;
        public final int version;
        public final Type paramType;
        public final Adapter converter;
        public final Adapter itemConverter;
        public final ObjectConverter.Reader objectConverter;
        public final boolean primitive;
        public final boolean array;

        public Setter(AccessMode.Writer writer, boolean primitive, boolean array, Type paramType, MapperConverter converter, ObjectConverter.Reader providedObjectConverter, int version) {
            this.writer = writer;
            this.paramType = paramType;
            this.version = version;
            this.primitive = primitive;
            this.array = array;
            ConverterAdapter theConverter = null;
            ConverterAdapter theItemConverter = null;
            ObjectConverter.Reader theObjectConverter = providedObjectConverter;
            if (converter != null) {
                if (converter instanceof ObjectConverter.Reader) {
                    theObjectConverter = (ObjectConverter.Reader)converter;
                }
                if (theObjectConverter == null) {
                    ConverterAdapter adapter = converter instanceof Converter ? new ConverterAdapter((Converter)converter) : (ConverterAdapter)converter;
                    if (Converters.matches(writer.getType(), adapter)) {
                        theConverter = adapter;
                    } else {
                        theItemConverter = adapter;
                    }
                }
            }
            this.converter = theConverter;
            this.itemConverter = theItemConverter;
            this.objectConverter = theObjectConverter;
        }

        public String toString() {
            return "Setter{writer=" + this.writer + ", version=" + this.version + ", paramType=" + this.paramType + ", converter=" + this.converter + ", itemConverter=" + this.itemConverter + ", primitive=" + this.primitive + ", array=" + this.array + '}';
        }
    }

    public static class Getter {
        public final AccessMode.Reader reader;
        public final int version;
        public final Adapter converter;
        public final Adapter itemConverter;
        public final ObjectConverter.Writer objectConverter;
        public final boolean dynamic;
        public final boolean primitive;
        public final boolean array;
        public final boolean map;
        public final boolean collection;
        public final Collection<String> ignoreNested;

        public Getter(AccessMode.Reader reader, boolean dynamic, boolean primitive, boolean array, boolean collection, boolean map, MapperConverter converter, ObjectConverter.Writer providedObjectConverter, int version, String[] ignoreNested) {
            this.reader = reader;
            this.version = version;
            ConverterAdapter theConverter = null;
            ConverterAdapter theItemConverter = null;
            ObjectConverter.Writer theObjectConverter = providedObjectConverter;
            if (converter != null) {
                if (converter instanceof ObjectConverter.Writer) {
                    theObjectConverter = (ObjectConverter.Writer)converter;
                }
                if (theObjectConverter == null) {
                    ConverterAdapter adapter = converter instanceof Converter ? new ConverterAdapter((Converter)converter) : (ConverterAdapter)converter;
                    if (Converters.matches(reader.getType(), adapter)) {
                        theConverter = adapter;
                    } else {
                        theItemConverter = adapter;
                    }
                }
            }
            this.converter = theConverter;
            this.itemConverter = theItemConverter;
            this.objectConverter = theObjectConverter;
            Collection<String> collection2 = this.ignoreNested = ignoreNested == null || ignoreNested.length == 0 ? null : new HashSet<String>(Arrays.asList(ignoreNested));
            if (converter == null) {
                this.dynamic = dynamic;
                this.array = array;
                this.collection = collection;
                this.primitive = primitive;
                this.map = map;
            } else {
                this.dynamic = true;
                this.array = array;
                this.collection = collection;
                this.primitive = primitive;
                this.map = false;
            }
        }

        public String toString() {
            return "Getter{reader=" + this.reader + ", version=" + this.version + ", converter=" + this.converter + ", itemConverter=" + this.itemConverter + ", primitive=" + this.primitive + ", array=" + this.array + ", map=" + this.map + ", collection=" + this.collection + '}';
        }
    }

    public static class CollectionMapping {
        public final Class<?> raw;
        public final Type arg;
        public final boolean primitive;

        public CollectionMapping(boolean primitive, Class<?> collectionType, Type fieldArgType) {
            this.raw = collectionType;
            this.arg = fieldArgType;
            this.primitive = primitive;
        }
    }

    public static class ClassMapping {
        public final Class<?> clazz;
        public final AccessMode.Factory factory;
        public final Map<String, Getter> getters;
        public final Map<String, Setter> setters;
        public final Adapter adapter;
        public final ObjectConverter.Reader reader;
        public final ObjectConverter.Writer writer;
        public final Getter anyGetter;
        public final Method anySetter;
        public final Method mapAdder;
        public final Class<?> mapAdderType;
        private Boolean deduplicateObjects;
        private boolean deduplicationEvaluated = false;

        protected ClassMapping(Class<?> clazz, AccessMode.Factory factory, Map<String, Getter> getters, Map<String, Setter> setters, Adapter<?, ?> adapter, ObjectConverter.Reader<?> reader, ObjectConverter.Writer<?> writer, Getter anyGetter, Method anySetter, Method mapAdder) {
            this.clazz = clazz;
            this.factory = factory;
            this.getters = getters;
            this.setters = setters;
            this.adapter = adapter;
            this.writer = writer;
            this.reader = reader;
            this.anyGetter = anyGetter;
            this.anySetter = anySetter;
            this.mapAdder = mapAdder;
            this.mapAdderType = mapAdder == null ? null : mapAdder.getParameterTypes()[1];
        }

        public Boolean isDeduplicateObjects() {
            if (!this.deduplicationEvaluated) {
                JohnzonDeduplicateObjects jdo = this.clazz.getAnnotation(JohnzonDeduplicateObjects.class);
                if (jdo != null) {
                    this.deduplicateObjects = jdo.value();
                }
                this.deduplicationEvaluated = true;
            }
            return this.deduplicateObjects;
        }
    }
}

