/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.Meta;

public class MethodAccessMode
extends BaseAccessMode {
    private final boolean supportGetterAsWritter;

    public MethodAccessMode(boolean useConstructor, boolean acceptHiddenConstructor, boolean supportGetterAsWritter) {
        super(useConstructor, acceptHiddenConstructor);
        this.supportGetterAsWritter = supportGetterAsWritter;
    }

    @Override
    public Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || readMethod.getDeclaringClass() == Object.class || this.isIgnored(descriptor.getName()) || Meta.getAnnotation(readMethod, JohnzonAny.class) != null) continue;
            readers.put(this.extractKey(descriptor.getName(), readMethod, null), new MethodReader(readMethod, this.fixType(clazz, readMethod.getGenericReturnType())));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            if (descriptor.getPropertyType() == Class.class || this.isIgnored(descriptor.getName())) continue;
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod != null) {
                writers.put(this.extractKey(descriptor.getName(), writeMethod, descriptor.getReadMethod()), new MethodWriter(writeMethod, this.fixType(clazz, writeMethod.getGenericParameterTypes()[0])));
                continue;
            }
            if (!this.supportGetterAsWritter || !Collection.class.isAssignableFrom(descriptor.getPropertyType()) || descriptor.getReadMethod() == null) continue;
            Method readMethod = descriptor.getReadMethod();
            writers.put(this.extractKey(descriptor.getName(), readMethod, null), new MethodGetterAsWriter(readMethod, this.fixType(clazz, readMethod.getGenericReturnType())));
        }
        return writers;
    }

    private String extractKey(String name, Method from, Method or) {
        JohnzonProperty property = Meta.getAnnotation(from, JohnzonProperty.class);
        if (property == null && or != null) {
            property = Meta.getAnnotation(or, JohnzonProperty.class);
        }
        return property != null ? property.value() : name;
    }

    protected boolean isIgnored(String name) {
        return name.equals("metaClass") || name.contains("$");
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        try {
            propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        return propertyDescriptors;
    }

    private class MethodGetterAsWriter
    extends MethodReader
    implements AccessMode.Writer {
        public MethodGetterAsWriter(Method readMethod, Type type) {
            super(readMethod, type);
        }

        @Override
        public void write(Object instance, Object value) {
            if (value != null) {
                try {
                    Collection collection = (Collection)Collection.class.cast(this.method.invoke(instance, new Object[0]));
                    if (collection != null) {
                        collection.addAll((Collection)Collection.class.cast(value));
                    }
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
            }
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            return null;
        }
    }

    public static class MethodReader
    extends MethodDecoratedType
    implements AccessMode.Reader {
        public MethodReader(Method method, Type type) {
            super(method, type);
        }

        @Override
        public Object read(Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            return null;
        }
    }

    public static class MethodWriter
    extends MethodDecoratedType
    implements AccessMode.Writer {
        public MethodWriter(Method method, Type type) {
            super(method, type);
        }

        @Override
        public void write(Object instance, Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            return null;
        }
    }

    public static abstract class MethodDecoratedType
    implements AccessMode.DecoratedType {
        protected final Method method;
        protected final Type type;

        public MethodDecoratedType(Method method, Type type) {
            this.method = method;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            this.type = type;
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            Class<?> declaringClass = this.method.getDeclaringClass();
            T annotation = Meta.getAnnotation(declaringClass, clazz);
            return annotation == null ? Meta.getAnnotation(declaringClass.getPackage(), clazz) : annotation;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return Meta.getAnnotation(this.method, clazz);
        }

        @Override
        public boolean isNillable() {
            return false;
        }
    }
}

