/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public abstract class BaseAccessMode
implements AccessMode {
    private static final Type[] NO_PARAMS = new Type[0];
    private final Map<Class<?>, String[]> fieldsToRemove = new HashMap();
    private final boolean acceptHiddenConstructor;
    private final boolean useConstructor;

    protected BaseAccessMode(boolean useConstructor, boolean acceptHiddenConstructor) {
        this.useConstructor = useConstructor;
        this.acceptHiddenConstructor = acceptHiddenConstructor;
        this.fieldsToRemove.put(Throwable.class, new String[]{"suppressedExceptions", "cause"});
    }

    protected abstract Map<String, AccessMode.Reader> doFindReaders(Class<?> var1);

    protected abstract Map<String, AccessMode.Writer> doFindWriters(Class<?> var1);

    @Override
    public Comparator<String> fieldComparator(Class<?> clazz) {
        return null;
    }

    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindReaders(clazz));
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindWriters(clazz));
    }

    public Map<Class<?>, String[]> getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    @Override
    public ObjectConverter.Reader<?> findReader(Class<?> clazz) {
        return null;
    }

    @Override
    public ObjectConverter.Writer<?> findWriter(Class<?> clazz) {
        return null;
    }

    @Override
    public Adapter<?, ?> findAdapter(Class<?> clazz) {
        return null;
    }

    @Override
    public void afterParsed(Class<?> clazz) {
    }

    @Override
    public AccessMode.Factory findFactory(final Class<?> clazz) {
        Constructor<?> cons;
        Adapter[] constructorItemParameterConverters;
        Adapter[] constructorParameterConverters;
        String[] constructorParameters;
        Type[] factoryParameterTypes;
        boolean constructorHasArguments;
        Constructor<?> constructor = null;
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (c.getParameterTypes().length == 0) {
                if (!Modifier.isPublic(c.getModifiers()) && this.acceptHiddenConstructor) {
                    c.setAccessible(true);
                }
                constructor = c;
                if (this.useConstructor) continue;
                break;
            }
            if (c.getAnnotation(ConstructorProperties.class) == null) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        boolean bl = constructorHasArguments = constructor != null && constructor.getGenericParameterTypes().length > 0;
        if (constructorHasArguments) {
            factoryParameterTypes = constructor.getGenericParameterTypes();
            constructorParameters = new String[constructor.getGenericParameterTypes().length];
            ConstructorProperties constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
            System.arraycopy(constructorProperties.value(), 0, constructorParameters, 0, constructorParameters.length);
            constructorParameterConverters = new Adapter[constructor.getGenericParameterTypes().length];
            constructorItemParameterConverters = new Adapter[constructorParameterConverters.length];
            for (int i = 0; i < constructorParameters.length; ++i) {
                for (Annotation a : constructor.getParameterAnnotations()[i]) {
                    if (a.annotationType() != JohnzonConverter.class) continue;
                    try {
                        MapperConverter mapperConverter = ((JohnzonConverter)JohnzonConverter.class.cast(a)).value().newInstance();
                        if (mapperConverter instanceof Converter) {
                            ConverterAdapter converter = new ConverterAdapter((Converter)mapperConverter);
                            if (Converters.matches(constructor.getParameterTypes()[i], converter)) {
                                constructorParameterConverters[i] = converter;
                                constructorItemParameterConverters[i] = null;
                                continue;
                            }
                            constructorParameterConverters[i] = null;
                            constructorItemParameterConverters[i] = converter;
                            continue;
                        }
                        throw new UnsupportedOperationException("TODO implement");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        } else {
            factoryParameterTypes = NO_PARAMS;
            constructorParameters = null;
            constructorParameterConverters = null;
            constructorItemParameterConverters = null;
        }
        if ((cons = constructor) != null && !cons.isAccessible()) {
            cons.setAccessible(true);
        }
        return new AccessMode.Factory(){

            @Override
            public Object create(Object[] params) {
                if (cons == null) {
                    throw new IllegalArgumentException(clazz.getName() + " can't be instantiated by Johnzon, this is a write only class");
                }
                try {
                    return params == null ? cons.newInstance(new Object[0]) : cons.newInstance(params);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            @Override
            public Type[] getParameterTypes() {
                return factoryParameterTypes;
            }

            @Override
            public String[] getParameterNames() {
                return constructorParameters;
            }

            @Override
            public Adapter<?, ?>[] getParameterConverter() {
                return constructorParameterConverters;
            }

            @Override
            public Adapter<?, ?>[] getParameterItemConverter() {
                return constructorItemParameterConverters;
            }
        };
    }

    @Override
    public Method findAnyGetter(Class<?> clazz) {
        Method m = null;
        for (Method current : clazz.getMethods()) {
            if (current.getAnnotation(JohnzonAny.class) == null || current.getParameterTypes().length != 0) continue;
            if (!Map.class.isAssignableFrom(current.getReturnType())) {
                throw new IllegalArgumentException("@JohnzonAny getters can only return a Map<String, Object>");
            }
            if (m != null) {
                throw new IllegalArgumentException("Ambiguous @JohnzonAny on " + m + " and " + current);
            }
            m = current;
        }
        return m;
    }

    @Override
    public Method findAnySetter(Class<?> clazz) {
        Method m = null;
        for (Method current : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (current.getAnnotation(JohnzonAny.class) == null || (parameterTypes = current.getParameterTypes()).length != 2 || parameterTypes[0] != String.class || parameterTypes[1] != Object.class) continue;
            if (m != null) {
                throw new IllegalArgumentException("Ambiguous @JohnzonAny on " + m + " and " + current);
            }
            m = current;
        }
        return m;
    }

    private <T> Map<String, T> sanitize(Class<?> type, Map<String, T> delegate) {
        for (Map.Entry<Class<?>, String[]> entry : this.fieldsToRemove.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            for (String field : entry.getValue()) {
                delegate.remove(field);
            }
            return delegate;
        }
        return delegate;
    }

    protected Type fixType(Class<?> clazz, Type type) {
        if (TypeVariable.class.isInstance(type)) {
            return this.fixTypeVariable(clazz, type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            if (actualTypeArguments.length == 1 && Class.class.isInstance(pt.getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) && ((Class)Class.class.cast(pt.getRawType())).getName().startsWith("java.util.") && TypeVariable.class.isInstance(actualTypeArguments[0])) {
                return new JohnzonParameterizedType(pt.getRawType(), this.fixTypeVariable(clazz, actualTypeArguments[0]));
            }
            if (actualTypeArguments.length == 2 && Class.class.isInstance(pt.getRawType()) && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) && ((Class)Class.class.cast(pt.getRawType())).getName().startsWith("java.util.") && TypeVariable.class.isInstance(actualTypeArguments[1])) {
                return new JohnzonParameterizedType(pt.getRawType(), actualTypeArguments[0], this.fixTypeVariable(clazz, actualTypeArguments[1]));
            }
        }
        return type;
    }

    private Type fixTypeVariable(Class<?> clazz, Type type) {
        ParameterizedType pt;
        TypeVariable<Class<?>>[] typeParameters;
        int idx;
        TypeVariable typeVariable = (TypeVariable)TypeVariable.class.cast(type);
        Class<?> classWithDeclaration = this.findClass(clazz.getSuperclass(), (GenericDeclaration)typeVariable.getGenericDeclaration());
        if (classWithDeclaration != null && (idx = Arrays.asList(typeParameters = classWithDeclaration.getTypeParameters()).indexOf(typeVariable)) >= 0 && (pt = this.findParameterizedType(clazz, classWithDeclaration)) != null && pt.getActualTypeArguments().length == typeParameters.length) {
            return pt.getActualTypeArguments()[idx];
        }
        return type;
    }

    private Class<?> findClass(Class<?> clazz, GenericDeclaration genericDeclaration) {
        if (clazz == null || clazz == genericDeclaration) {
            return clazz;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            return this.findClass(superclass, genericDeclaration);
        }
        return null;
    }

    private ParameterizedType findParameterizedType(Class<?> clazz, Class<?> classWithDeclaration) {
        if (clazz == Object.class) {
            return null;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && ((ParameterizedType)genericSuperclass).getRawType() == classWithDeclaration) {
            return (ParameterizedType)genericSuperclass;
        }
        return this.findParameterizedType(clazz.getSuperclass(), classWithDeclaration);
    }
}

