/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs.jsonb.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonStructure;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JsonbJaxrsProvider<T>
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    private final Collection<String> ignores;
    private final AtomicReference<Jsonb> delegate = new AtomicReference();
    private final JsonbConfig config = new JsonbConfig();

    public JsonbJaxrsProvider() {
        this(null);
    }

    protected JsonbJaxrsProvider(Collection<String> ignores) {
        this.ignores = ignores;
    }

    protected Jsonb createJsonb() {
        return JsonbBuilder.create((JsonbConfig)this.config);
    }

    private boolean isIgnored(Class<?> type) {
        return this.ignores != null && this.ignores.contains(type.getName());
    }

    public void setFailOnUnknownProperties(boolean active) {
        this.config.setProperty("johnzon.fail-on-unknown-properties", (Object)active);
    }

    public void setOtherProperties(final String others) {
        Properties properties = new Properties(){
            {
                try {
                    this.load(new StringReader(others));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        properties.stringPropertyNames().forEach(k -> this.config.setProperty(k, (Object)properties.getProperty((String)k)));
    }

    public void setIJson(boolean active) {
        this.config.withStrictIJSON(Boolean.valueOf(active));
    }

    public void setEncoding(String encoding) {
        this.config.withEncoding(encoding);
    }

    public void setBinaryDataStrategy(String binaryDataStrategy) {
        this.config.withBinaryDataStrategy(binaryDataStrategy);
    }

    public void setPropertyNamingStrategy(String propertyNamingStrategy) {
        this.config.withPropertyNamingStrategy(propertyNamingStrategy);
    }

    public void setPropertyOrderStrategy(String propertyOrderStrategy) {
        this.config.withPropertyOrderStrategy(propertyOrderStrategy);
    }

    public void setNullValues(boolean nulls) {
        this.config.withNullValues(Boolean.valueOf(nulls));
    }

    public void setPretty(boolean pretty) {
        this.config.withFormatting(Boolean.valueOf(pretty));
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(type) && !InputStream.class.isAssignableFrom(type) && !Reader.class.isAssignableFrom(type) && !Response.class.isAssignableFrom(type) && !CharSequence.class.isAssignableFrom(type) && !JsonStructure.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(type) && !InputStream.class.isAssignableFrom(type) && !OutputStream.class.isAssignableFrom(type) && !Writer.class.isAssignableFrom(type) && !StreamingOutput.class.isAssignableFrom(type) && !CharSequence.class.isAssignableFrom(type) && !Response.class.isAssignableFrom(type) && !JsonStructure.class.isAssignableFrom(type);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return (T)this.delegate().fromJson(entityStream, genericType);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.delegate().toJson(t, entityStream);
    }

    private Jsonb delegate() {
        Jsonb jsonb = this.delegate.get();
        if (jsonb == null) {
            Jsonb newJsonb = this.createJsonb();
            jsonb = this.delegate.compareAndSet(null, newJsonb) ? newJsonb : this.delegate.get();
        }
        return jsonb;
    }
}

