/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.jorphan.collections.HashTree;

public class SortedHashTree
extends HashTree
implements Serializable {
    private static final long serialVersionUID = 233L;

    public SortedHashTree() {
        super(new TreeMap<Object, HashTree>());
    }

    public SortedHashTree(Comparator<? super Object> comper) {
        super(new TreeMap<Object, HashTree>(comper));
    }

    public SortedHashTree(Object key) {
        this();
        this.data.put(key, new SortedHashTree());
    }

    public SortedHashTree(Object key, Comparator<? super Object> comper) {
        this(comper);
        this.data.put(key, new SortedHashTree(comper));
    }

    public SortedHashTree(Collection<?> keys) {
        this();
        for (Object key : keys) {
            this.data.put(key, new SortedHashTree());
        }
    }

    public SortedHashTree(Collection<?> keys, Comparator<? super Object> comper) {
        this(comper);
        for (Object key : keys) {
            this.data.put(key, new SortedHashTree(comper));
        }
    }

    public SortedHashTree(Object[] keys) {
        this();
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new SortedHashTree());
        }
    }

    public SortedHashTree(Object[] keys, Comparator<? super Object> comper) {
        this(comper);
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new SortedHashTree(comper));
        }
    }

    @Override
    protected HashTree createNewTree() {
        Comparator comparator = ((TreeMap)this.data).comparator();
        return new SortedHashTree(comparator);
    }

    @Override
    protected HashTree createNewTree(Object key) {
        Comparator comparator = ((TreeMap)this.data).comparator();
        return new SortedHashTree(key, comparator);
    }

    @Override
    protected HashTree createNewTree(Collection<?> values) {
        Comparator comparator = ((TreeMap)this.data).comparator();
        return new SortedHashTree(values, comparator);
    }
}

