/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class HttpMirrorThread
implements Runnable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final byte[] CRLF = new byte[]{13, 10};
    private final Socket clientSocket;

    public HttpMirrorThread(Socket _clientSocket) {
        this.clientSocket = _clientSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        log.debug("Starting thread");
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            String transferEncodingHeaderValue;
            String sleepHeaderValue;
            String cookieHeaderValue;
            in = new BufferedInputStream(this.clientSocket.getInputStream());
            int contentLength = -1;
            boolean isChunked = false;
            byte[] buffer = new byte[1024];
            StringBuilder headers = new StringBuilder();
            int length = 0;
            int positionOfBody = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (positionOfBody <= 0 && (length = in.read(buffer)) != -1) {
                log.debug("Write body");
                baos.write(buffer, 0, length);
                headers.append(new String(buffer, 0, length, ISO_8859_1));
                positionOfBody = HttpMirrorThread.getPositionOfBody(headers.toString());
            }
            baos.close();
            String headerString = headers.toString();
            String responseStatusValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-ResponseStatus");
            if (responseStatusValue == null) {
                responseStatusValue = "200 OK";
            }
            log.debug("Write headers");
            out = new BufferedOutputStream(this.clientSocket.getOutputStream());
            out.write(("HTTP/1.0 " + responseStatusValue).getBytes(ISO_8859_1));
            out.write(CRLF);
            out.write("Content-Type: text/plain".getBytes(ISO_8859_1));
            out.write(CRLF);
            String responseLengthValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-ResponseLength");
            int responseLength = -1;
            if (responseLengthValue != null) {
                responseLength = Integer.parseInt(responseLengthValue);
            }
            if ((cookieHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-SetCookie")) != null) {
                out.write("Set-Cookie: ".getBytes(ISO_8859_1));
                out.write(cookieHeaderValue.getBytes(ISO_8859_1));
                out.write(CRLF);
            }
            out.write(CRLF);
            out.flush();
            if (responseLength >= 0) {
                out.write(baos.toByteArray(), 0, Math.min(baos.toByteArray().length, responseLength));
            } else {
                out.write(baos.toByteArray());
            }
            String contentLengthHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "Content-Length");
            if (contentLengthHeaderValue != null) {
                contentLength = Integer.parseInt(contentLengthHeaderValue);
            }
            if ((sleepHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-Sleep")) != null) {
                TimeUnit.MILLISECONDS.sleep(Integer.parseInt(sleepHeaderValue));
            }
            if ((transferEncodingHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "Transfer-Encoding")) != null && !(isChunked = transferEncodingHeaderValue.equalsIgnoreCase("chunked"))) {
                log.error("Transfer-Encoding header set, the value is not supported : " + transferEncodingHeaderValue);
            }
            length = 0;
            if (contentLength > 0) {
                int totalReadBytes = headerString.length() - positionOfBody - 2;
                log.debug("Reading, " + totalReadBytes + " < " + contentLength);
                while (totalReadBytes < contentLength && (length = in.read(buffer)) != -1) {
                    log.debug("Read bytes: " + length);
                    out.write(buffer, 0, length);
                    log.debug("totalReadBytes: " + (totalReadBytes += length));
                }
            } else if (isChunked) {
                log.debug("Chunked");
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
            } else {
                log.debug("Other");
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    log.debug("Read bytes: " + length);
                    out.write(buffer, 0, length);
                }
            }
            log.debug("Flush");
            out.flush();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            JOrphanUtils.closeQuietly(out);
            JOrphanUtils.closeQuietly((Closeable)in);
            JOrphanUtils.closeQuietly((Socket)this.clientSocket);
        }
        catch (InterruptedException e2) {
            log.error("", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    JOrphanUtils.closeQuietly(out);
                    JOrphanUtils.closeQuietly(in);
                    JOrphanUtils.closeQuietly((Socket)this.clientSocket);
                    throw throwable;
                }
            }
            JOrphanUtils.closeQuietly(out);
            JOrphanUtils.closeQuietly((Closeable)in);
            JOrphanUtils.closeQuietly((Socket)this.clientSocket);
        }
        JOrphanUtils.closeQuietly((Closeable)out);
        JOrphanUtils.closeQuietly((Closeable)in);
        JOrphanUtils.closeQuietly((Socket)this.clientSocket);
        log.debug("End of Thread");
    }

    private static String getRequestHeaderValue(String requestHeaders, String headerName) {
        String expression;
        Pattern pattern;
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(requestHeaders, pattern = JMeterUtils.getPattern((String)(expression = "^" + headerName + ":\\s+([^\\r\\n]+)"), (int)32777))) {
            return localMatcher.getMatch().group(1);
        }
        return null;
    }

    private static int getPositionOfBody(String stringToCheck) {
        String regularExpression;
        Pattern pattern;
        PatternMatcherInput input;
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(input = new PatternMatcherInput(stringToCheck), pattern = JMeterUtils.getPattern((String)(regularExpression = "^\\r$"), (int)32777))) {
            MatchResult match = localMatcher.getMatch();
            return match.beginOffset(0);
        }
        return -1;
    }
}

