/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.jmespath;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import io.burt.jmespath.Expression;
import java.io.Serializable;
import java.util.Objects;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.extractor.json.jmespath.JMESPathCache;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMESPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion,
TestStateListener {
    private static final long serialVersionUID = -6448744108529796508L;
    private static final Logger log = LoggerFactory.getLogger(JMESPathAssertion.class);
    private static final String JMESPATH = "JMES_PATH";
    private static final String EXPECTEDVALUE = "EXPECTED_VALUE";
    private static final String JSONVALIDATION = "JSONVALIDATION";
    private static final String EXPECT_NULL = "EXPECT_NULL";
    private static final String INVERT = "INVERT";
    private static final String ISREGEX = "ISREGEX";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");

    private void doAssert(AssertionResult assertionResult, String responseDataAsJsonString, boolean invert) throws Exception {
        JsonNode input = (JsonNode)OBJECT_MAPPER.readValue(responseDataAsJsonString, JsonNode.class);
        Expression<JsonNode> expression = JMESPathCache.getInstance().get(this.getJmesPath());
        JsonNode currentValue = (JsonNode)expression.search((Object)input);
        log.debug("JMESPath query {} invoked on response {}. Query result is {}. ", new Object[]{expression, responseDataAsJsonString, currentValue});
        boolean success = this.checkResult(OBJECT_MAPPER, currentValue);
        if (!invert) {
            if (!success) {
                this.failAssertion(invert, assertionResult);
            }
        } else if (success) {
            this.failAssertion(invert, assertionResult);
        }
    }

    private String buildFailureMessage(boolean invert) {
        StringBuilder message = new StringBuilder();
        if (!this.isJsonValidationBool()) {
            message.append("JMESPATH ").append(this.getJmesPath()).append(" expected");
            this.addNegation(invert, message);
            message.append(" to exist");
        } else {
            message.append("Value expected");
            if (this.isExpectNull()) {
                this.addNegation(invert, message);
                message.append(" to be null");
            } else if (this.isUseRegex()) {
                this.addNegation(invert, message);
                message.append(" to match ");
                message.append(this.getExpectedValue());
            } else {
                this.addNegation(invert, message);
                message.append(" to be equal to ");
                message.append(this.getExpectedValue());
            }
        }
        return message.toString();
    }

    private void addNegation(boolean invert, StringBuilder message) {
        if (invert) {
            message.append(" not");
        }
    }

    private boolean checkResult(ObjectMapper mapper, JsonNode jsonNode) throws JsonProcessingException {
        if (!this.isJsonValidationBool()) {
            return !(jsonNode instanceof NullNode);
        }
        if (this.isExpectNull()) {
            return jsonNode instanceof NullNode;
        }
        return this.isEquals(mapper, jsonNode);
    }

    private AssertionResult failAssertion(boolean invert, AssertionResult assertionResult) {
        assertionResult.setFailure(true);
        assertionResult.setFailureMessage(this.buildFailureMessage(invert));
        return assertionResult;
    }

    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result;
        block3: {
            result = new AssertionResult(this.getName());
            String responseData = samplerResult.getResponseDataAsString();
            if (responseData.isEmpty()) {
                return result.setResultForNull();
            }
            result.setFailure(false);
            result.setFailureMessage("");
            try {
                this.doAssert(result, responseData, this.isInvert());
            }
            catch (Exception e) {
                if (this.isInvert()) break block3;
                result.setError(true);
                result.setFailureMessage(e.getMessage());
            }
        }
        return result;
    }

    public static String objectToString(ObjectMapper mapper, JsonNode element) throws JsonProcessingException {
        if (element.isTextual()) {
            return element.asText();
        }
        return mapper.writeValueAsString((Object)element);
    }

    private boolean isEquals(ObjectMapper mapper, JsonNode jsonNode) throws JsonProcessingException {
        String str = JMESPathAssertion.objectToString(mapper, jsonNode);
        if (this.isUseRegex()) {
            if (USE_JAVA_REGEX) {
                return JMeterUtils.compilePattern((String)this.getExpectedValue()).matcher(str).matches();
            }
            Pattern pattern = JMeterUtils.getPatternCache().getPattern(this.getExpectedValue());
            return JMeterUtils.getMatcher().matches(str, pattern);
        }
        String expectedValueString = this.getExpectedValue();
        if (str.equals(expectedValueString)) {
            return true;
        }
        JsonNode expected = (JsonNode)OBJECT_MAPPER.readValue(expectedValueString, JsonNode.class);
        return Objects.equals(expected, jsonNode);
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        JMESPathCache.getInstance().cleanUp();
    }

    public String getJmesPath() {
        return this.getPropertyAsString(JMESPATH);
    }

    public void setJmesPath(String jmesPath) {
        this.setProperty(JMESPATH, jmesPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTEDVALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTEDVALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSONVALIDATION, jsonValidation);
    }

    public void setExpectNull(boolean val) {
        this.setProperty(EXPECT_NULL, val);
    }

    public boolean isExpectNull() {
        return this.getPropertyAsBoolean(EXPECT_NULL);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSONVALIDATION);
    }

    public void setInvert(boolean invert) {
        this.setProperty(INVERT, invert);
    }

    public boolean isInvert() {
        return this.getPropertyAsBoolean(INVERT);
    }

    public void setIsRegex(boolean flag) {
        this.setProperty(ISREGEX, flag);
    }

    public boolean isUseRegex() {
        return this.getPropertyAsBoolean(ISREGEX, true);
    }
}

