/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShellPostProcessor
extends BeanShellTestElement
implements Cloneable,
PostProcessor,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BeanShellPostProcessor.class);
    private static final long serialVersionUID = 5L;
    private static final String INIT_FILE = "beanshell.postprocessor.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public void process() {
        block4: {
            JMeterContext jmctx = JMeterContextService.getContext();
            SampleResult prev = jmctx.getPreviousResult();
            if (prev == null) {
                return;
            }
            BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
            if (bshInterpreter == null) {
                log.error("BeanShell not found");
                return;
            }
            try {
                bshInterpreter.set("data", (Object)prev.getResponseData());
                this.processFileOrScript(bshInterpreter);
            }
            catch (JMeterException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn("Problem in BeanShell script: {}", (Object)e.toString());
            }
        }
    }

    public Object clone() {
        return super.clone();
    }
}

