/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.IOException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.JSR223TestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223Assertion
extends JSR223TestElement
implements Cloneable,
Assertion,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(JSR223Assertion.class);
    private static final long serialVersionUID = 235L;

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        try {
            ScriptEngine scriptEngine = this.getScriptEngine();
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("SampleResult", (Object)response);
            bindings.put("AssertionResult", (Object)result);
            this.processFileOrScript(scriptEngine, bindings);
            result.setError(false);
        }
        catch (IOException | ScriptException e) {
            log.error("Problem in JSR223 script: {}", (Object)this.getName(), (Object)e);
            result.setError(true);
            result.setFailureMessage(e.toString());
        }
        return result;
    }

    public Object clone() {
        return super.clone();
    }
}

