/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.spatial.SpatialDocProducer;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMonitor;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphSpatial
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphSpatial.class);
    private final SpatialIndex spatialIndex;
    private boolean needFinish = false;

    public DatasetGraphSpatial(DatasetGraph dsg, SpatialIndex index, SpatialDocProducer producer) {
        super(dsg, (DatasetChanges)producer);
        this.spatialIndex = index;
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void begin(ReadWrite readWrite) {
        super.begin(readWrite);
        if (readWrite == ReadWrite.WRITE) {
            super.getMonitor().start();
            this.needFinish = true;
        }
    }

    public void commit() {
        try {
            if (this.needFinish) {
                super.getMonitor().finish();
            }
            this.needFinish = false;
            super.commit();
        }
        catch (Throwable ex) {
            log.warn("Exception in commit: " + ex.getMessage(), ex);
            super.abort();
        }
    }

    public void abort() {
        try {
            if (this.needFinish) {
                this.spatialIndex.abortIndexing();
            }
            super.abort();
        }
        catch (Throwable ex) {
            log.warn("Exception in abort: " + ex.getMessage(), ex);
        }
    }

    public boolean isInTransaction() {
        return super.isInTransaction();
    }

    public void end() {
        try {
            super.end();
        }
        catch (Throwable ex) {
            log.warn("Exception in end: " + ex.getMessage(), ex);
        }
    }

    public boolean supportsTransactions() {
        return super.supportsTransactions();
    }

    public boolean supportsTransactionAbort() {
        return super.supportsTransactionAbort();
    }
}

