/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.function.BiFunction;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.impl.factories.STDObjectFactories;
import org.apache.jena.ontapi.impl.objects.OntDisjointImpl;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;

final class OntDisjoints {
    public static final EnhNodeFinder PROPERTIES_FINDER = new EnhNodeFinder.ByType(OWL2.AllDisjointProperties);
    public static final EnhNodeFinder DISJOINT_FINDER = OntEnhNodeFactories.createFinder(OWL2.AllDisjointClasses, OWL2.AllDifferent, OWL2.AllDisjointProperties);

    OntDisjoints() {
    }

    public static EnhNodeFactory createDifferentIndividualsFactory(OntConfig config) {
        boolean useDistinctMembers = config.getBoolean(OntModelControls.USE_OWL1_DISTINCT_MEMBERS_PREDICATE_FEATURE);
        boolean compatible = config.getBoolean(OntModelControls.USE_OWL2_DEPRECATED_VOCABULARY_FEATURE);
        Property[] predicates = useDistinctMembers ? new Property[]{OWL2.distinctMembers} : (compatible ? new Property[]{OWL2.members, OWL2.distinctMembers} : new Property[]{OWL2.members});
        return OntDisjoints.createFactory(OntDisjointImpl.IndividualsImpl.class, (n, g) -> new OntDisjointImpl.IndividualsImpl((Node)n, (EnhGraph)g, !compatible, useDistinctMembers), OWL2.AllDifferent, OntIndividual.class, true, predicates);
    }

    public static EnhNodeFactory createFactory(Class<? extends OntDisjointImpl<?>> impl, BiFunction<Node, EnhGraph, EnhNode> producer, Resource type, Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, type, producer);
        EnhNodeFinder.ByType finder = new EnhNodeFinder.ByType(type);
        EnhNodeFilter filter = EnhNodeFilter.ANON.and(new EnhNodeFilter.HasType(type));
        return OntEnhNodeFactories.createCommon(maker, (EnhNodeFinder)finder, filter.and(OntDisjoints.getHasPredicatesFilter(predicates)).and(OntDisjoints.getHasMembersOfFilter(view, allowEmptyList, predicates)), new EnhNodeFilter[0]);
    }

    private static EnhNodeFilter getHasPredicatesFilter(Property ... predicates) {
        if (predicates.length == 0) {
            throw new IllegalArgumentException();
        }
        EnhNodeFilter res = new EnhNodeFilter.HasPredicate(predicates[0]);
        for (int i = 1; i < predicates.length; ++i) {
            res = res.or(new EnhNodeFilter.HasPredicate(predicates[i]));
        }
        return res;
    }

    private static EnhNodeFilter getHasMembersOfFilter(Class<? extends RDFNode> view, boolean allowEmptyList, Property ... predicates) {
        return (node, eg) -> {
            try (ExtendedIterator<Node> res = OntDisjoints.listRoots(node, eg.asGraph(), predicates);){
                while (res.hasNext()) {
                    if (!OntDisjoints.testList((Node)res.next(), eg, view, allowEmptyList)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        };
    }

    private static ExtendedIterator<Node> listRoots(Node node, Graph graph, Property ... predicates) {
        return Iterators.flatMap(Iterators.of(predicates), p -> graph.find(node, p.asNode(), Node.ANY).mapWith(Triple::getObject));
    }

    private static boolean testList(Node node, EnhGraph graph, Class<? extends RDFNode> view, boolean allowEmptyList) {
        if (!STDObjectFactories.RDF_LIST.canWrap(node, graph)) {
            return false;
        }
        if (view == null) {
            return true;
        }
        RDFList list = (RDFList)STDObjectFactories.RDF_LIST.wrap(node, graph);
        return list.isEmpty() && allowEmptyList || Iterators.anyMatch(list.iterator().mapWith(FrontsNode::asNode), n -> OntEnhGraph.canAs(view, n, graph));
    }
}

