/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.EnhNodeFactory;

public abstract class BaseEnhNodeFactoryImpl
extends Implementation
implements EnhNodeFactory {
    protected static EnhNode safeWrap(Node n, EnhGraph g, Iterable<EnhNodeFactory> factories) {
        for (EnhNodeFactory f : factories) {
            EnhNode r = BaseEnhNodeFactoryImpl.safeWrap(n, g, f);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    protected static EnhNode safeWrap(Node n, EnhGraph g, EnhNodeFactory f) {
        try {
            return f.wrap(n, g);
        }
        catch (OntJenaException.Conversion c) {
            return null;
        }
    }

    protected static boolean canWrap(Node node, EnhGraph eg, EnhNodeFactory ... factories) {
        for (EnhNodeFactory f : factories) {
            if (!f.canWrap(node, eg)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canWrap(Node node, EnhGraph eg, Iterable<EnhNodeFactory> factories) {
        for (EnhNodeFactory f : factories) {
            if (!f.canWrap(node, eg)) continue;
            return true;
        }
        return false;
    }

    protected static EnhNode wrap(Node node, EnhGraph eg, OntJenaException.Conversion ex, EnhNodeFactory ... factories) {
        for (EnhNodeFactory f : factories) {
            try {
                return f.wrap(node, eg);
            }
            catch (OntJenaException.Conversion c) {
                ex.addSuppressed((Throwable)((Object)c));
            }
        }
        throw ex;
    }

    protected static EnhNode wrap(Node node, EnhGraph eg, OntJenaException.Conversion ex, Iterable<EnhNodeFactory> factories) {
        for (EnhNodeFactory f : factories) {
            try {
                return f.wrap(node, eg);
            }
            catch (OntJenaException.Conversion c) {
                ex.addSuppressed((Throwable)((Object)c));
            }
        }
        throw ex;
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion("Can't wrap node " + node + ". Use direct factory.");
        }
        return this.createInstance(node, eg);
    }
}

