/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StringArrayMap
implements Serializable {
    private static final long serialVersionUID = -5833051164281786907L;
    private final Map map = new HashMap();

    public static String asString(Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        if (pValue instanceof String[]) {
            return ((String[])pValue)[0];
        }
        if (pValue instanceof List) {
            return (String)((List)pValue).get(0);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static String[] asStringArray(Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return new String[]{(String)pValue};
        }
        if (pValue instanceof String[]) {
            return (String[])pValue;
        }
        if (pValue instanceof List) {
            List l = (List)pValue;
            return l.toArray(new String[l.size()]);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static Enumeration asStringEnum(final Object pValue) {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof String) {
            return new Enumeration(){
                private Object value;
                {
                    this.value = pValue;
                }

                public boolean hasMoreElements() {
                    return this.value != null;
                }

                public Object nextElement() {
                    if (this.value == null) {
                        throw new NoSuchElementException();
                    }
                    String s = (String)this.value;
                    this.value = null;
                    return s;
                }
            };
        }
        if (pValue instanceof String[]) {
            final String[] values = (String[])pValue;
            return new Enumeration(){
                private int offset;

                public boolean hasMoreElements() {
                    return this.offset < values.length;
                }

                public Object nextElement() {
                    if (this.offset >= values.length) {
                        throw new NoSuchElementException();
                    }
                    return values[this.offset++];
                }
            };
        }
        if (pValue instanceof List) {
            return Collections.enumeration((List)pValue);
        }
        throw new IllegalStateException("Invalid parameter class: " + pValue.getClass().getName());
    }

    public static Map asMap(Map pMap) {
        Iterator iter = pMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String[] value = StringArrayMap.asStringArray(entry.getValue());
            entry.setValue(value);
        }
        return Collections.unmodifiableMap(pMap);
    }

    protected void addMapValue(Map pMap, String pName, String pValue) {
        Object o = pMap.get(pName);
        if (o == null) {
            o = pValue;
        } else if (o instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o);
            list.add(pValue);
            o = list;
        } else if (o instanceof List) {
            ((List)o).add(pValue);
        } else if (o instanceof String[]) {
            ArrayList<String> list = new ArrayList<String>();
            String[] arr = (String[])o;
            for (int i = 0; i < arr.length; ++i) {
                list.add(arr[i]);
            }
            list.add(pValue);
            o = list;
        } else {
            throw new IllegalStateException("Invalid object type: " + o.getClass().getName());
        }
        pMap.put(pName, o);
    }

    protected String convertName(String pName) {
        return pName.toLowerCase();
    }

    public String getValue(String pName) {
        return StringArrayMap.asString(this.map.get(this.convertName(pName)));
    }

    public String[] getValues(String pName) {
        return StringArrayMap.asStringArray(this.map.get(this.convertName(pName)));
    }

    public Enumeration getValueEnum(String pName) {
        return StringArrayMap.asStringEnum(this.map.get(this.convertName(pName)));
    }

    public Enumeration getNames() {
        return Collections.enumeration(this.map.keySet());
    }

    public Map getMap() {
        return StringArrayMap.asMap(this.map);
    }

    public void addValue(String pName, String pValue) {
        this.addMapValue(this.map, this.convertName(pName), pValue);
    }

    public String[] getNameArray() {
        Set c = this.map.keySet();
        return c.toArray(new String[c.size()]);
    }
}

