/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineBreakingOutputStream
extends FilterOutputStream {
    private static final byte[] CRLF = new byte[]{13, 10};
    private int linepos = 0;
    private int lineLength = 76;

    public LineBreakingOutputStream(OutputStream out, int lineLength) {
        super(out);
        this.lineLength = lineLength;
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (len + this.linepos > this.lineLength) {
                int count = this.lineLength - this.linepos;
                if (count > 0) {
                    this.out.write(b, off, count);
                    off += count;
                    len -= count;
                }
                this.out.write(CRLF);
                this.linepos = 0;
                continue;
            }
            this.out.write(b, off, len);
            this.linepos += len;
            len = 0;
        }
    }

    public final void write(int b) throws IOException {
        if (this.linepos >= this.lineLength) {
            this.out.write(CRLF);
            this.linepos = 0;
        }
        this.out.write(b);
        ++this.linepos;
    }
}

