/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.decoder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.decoder.ByteQueue;

public class Base64InputStream
extends InputStream {
    private static Log log = LogFactory.getLog((Class)Base64InputStream.class);
    private final InputStream s;
    private final ByteQueue byteq = new ByteQueue(3);
    private boolean done = false;
    private boolean closed = false;
    private static byte[] TRANSLATION = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public Base64InputStream(InputStream s) {
        this.s = s;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        byte val;
        if (this.closed) {
            throw new IOException("Base64InputStream has been closed");
        }
        if (this.byteq.count() == 0) {
            this.fillBuffer();
            if (this.byteq.count() == 0) {
                return -1;
            }
        }
        if ((val = this.byteq.dequeue()) >= 0) {
            return val;
        }
        return val & 0xFF;
    }

    private void fillBuffer() throws IOException {
        byte[] data = new byte[4];
        int pos = 0;
        block4: while (!this.done) {
            int i = this.s.read();
            switch (i) {
                case -1: {
                    if (pos > 0) {
                        log.warn((Object)("Unexpected EOF in MIME parser, dropping " + pos + " sextets"));
                    }
                    return;
                }
                case 61: {
                    this.decodeAndEnqueue(data, pos);
                    this.done = true;
                    continue block4;
                }
            }
            byte sX = TRANSLATION[i];
            if (sX < 0) continue;
            data[pos++] = sX;
            if (pos != data.length) continue;
            this.decodeAndEnqueue(data, pos);
            return;
        }
    }

    private void decodeAndEnqueue(byte[] data, int len) {
        int accum = 0;
        accum |= data[0] << 18;
        accum |= data[1] << 12;
        accum |= data[2] << 6;
        byte b1 = (byte)((accum |= data[3]) >>> 16);
        this.byteq.enqueue(b1);
        if (len > 2) {
            byte b2 = (byte)(accum >>> 8 & 0xFF);
            this.byteq.enqueue(b2);
            if (len > 3) {
                byte b3 = (byte)(accum & 0xFF);
                this.byteq.enqueue(b3);
            }
        }
    }
}

