/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.storage.AbstractStorageProvider;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public class MemoryStorageProvider
extends AbstractStorageProvider {
    @Override
    public StorageOutputStream createStorageOutputStream() {
        return new MemoryStorageOutputStream();
    }

    private static final class MemoryStorageOutputStream
    extends StorageOutputStream {
        final ByteArrayBuffer bab = new ByteArrayBuffer(1024);

        private MemoryStorageOutputStream() {
        }

        @Override
        protected void write0(byte[] buffer, int offset, int length) throws IOException {
            this.bab.append(buffer, offset, length);
        }

        @Override
        protected Storage toStorage0() throws IOException {
            return new MemoryStorage(this.bab.buffer(), this.bab.length());
        }
    }

    static final class MemoryStorage
    implements Storage {
        private byte[] data;
        private final int count;

        public MemoryStorage(byte[] data, int count) {
            this.data = data;
            this.count = count;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.data == null) {
                throw new IllegalStateException("storage has been deleted");
            }
            return new ByteArrayInputStream(this.data, 0, this.count);
        }

        @Override
        public void delete() {
            this.data = null;
        }
    }
}

