/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.impl.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationMessageErrorHandler
extends DefaultHandler {
    private final Set<ValidationMessage> messages = new LinkedHashSet<ValidationMessage>();
    private final ValidationMessageSeverity errorMessageSeverity;

    public ValidationMessageErrorHandler(ValidationMessageSeverity errorMessageSeverity) {
        this.errorMessageSeverity = errorMessageSeverity;
    }

    private void print(@NotNull SAXParseException x, @NotNull ValidationMessageSeverity severity) {
        ValidationMessage message = new ValidationMessage(severity, x.getMessage(), x.getLineNumber(), x.getColumnNumber(), null);
        this.messages.add(message);
    }

    @Override
    public void warning(SAXParseException x) {
        this.print(x, ValidationMessageSeverity.WARN);
    }

    @Override
    public void error(SAXParseException x) {
        this.print(x, this.errorMessageSeverity);
    }

    @Override
    public void fatalError(SAXParseException x) throws SAXParseException {
        this.print(x, ValidationMessageSeverity.ERROR);
        throw x;
    }

    public Collection<ValidationMessage> getValidationMessages() {
        return this.messages;
    }
}

