/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LastRevs;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.memory.MemoryDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SplitOperations.class);
    private static final int GARBAGE_LIMIT = Integer.getInteger("oak.documentMK.garbage.limit", 1000);
    private static final Predicate<Long> BINARY_FOR_SPLIT_THRESHOLD = new Predicate<Long>(){

        public boolean apply(Long input) {
            return input > 4096L;
        }
    };
    private static final DocumentStore STORE = new MemoryDocumentStore();
    private final NodeDocument doc;
    private final Path path;
    private final String id;
    private final Revision headRevision;
    private final RevisionContext context;
    private final Function<String, Long> binarySize;
    private final int numRevsThreshold;
    private Revision high;
    private Revision low;
    private int numValues;
    private boolean hasBinaryToSplit;
    private Supplier<Boolean> nodeExistsAtHeadRevision;
    private Map<String, NavigableMap<Revision, String>> committedChanges;
    private Set<Revision> changes;
    private Map<String, Set<Revision>> garbage;
    private int garbageCount = 0;
    private Set<Revision> mostRecentRevs;
    private Set<Revision> splitRevs;
    private List<UpdateOp> splitOps;
    private UpdateOp main;

    private SplitOperations(final @NotNull NodeDocument doc, final @NotNull RevisionContext context, final @NotNull RevisionVector headRev, @NotNull Function<String, Long> binarySize, int numRevsThreshold) {
        this.doc = (NodeDocument)Preconditions.checkNotNull((Object)doc);
        this.context = (RevisionContext)Preconditions.checkNotNull((Object)context);
        this.binarySize = (Function)Preconditions.checkNotNull(binarySize);
        this.path = doc.getPath();
        this.id = doc.getId();
        this.headRevision = ((RevisionVector)Preconditions.checkNotNull((Object)headRev)).getRevision(context.getClusterId());
        this.numRevsThreshold = numRevsThreshold;
        this.nodeExistsAtHeadRevision = Suppliers.memoize((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return doc.getLiveRevision(context, headRev, Maps.newHashMap(), new LastRevs(headRev)) != null;
            }
        });
    }

    @NotNull
    static List<UpdateOp> forDocument(@NotNull NodeDocument doc, @NotNull RevisionContext context, @NotNull RevisionVector headRevision, @NotNull Function<String, Long> binarySize, int numRevsThreshold) {
        if (doc.isSplitDocument()) {
            throw new IllegalArgumentException("Not a main document: " + doc.getId());
        }
        return new SplitOperations(doc, context, headRevision, binarySize, numRevsThreshold).create();
    }

    private List<UpdateOp> create() {
        if (!this.considerSplit()) {
            return Collections.emptyList();
        }
        this.splitOps = Lists.newArrayList();
        this.mostRecentRevs = Sets.newHashSet();
        this.splitRevs = Sets.newHashSet();
        this.garbage = Maps.newHashMap();
        this.changes = Sets.newHashSet();
        this.committedChanges = Maps.newHashMap();
        this.collectLocalChanges(this.committedChanges, this.changes);
        this.populateSplitRevs();
        this.collectRevisionsAndCommitRoot();
        this.main = this.createSplitOps();
        this.createIntermediateDocs();
        this.disconnectStalePrevDocs();
        this.removeGarbage();
        if (this.main != null) {
            this.splitOps.add(this.main);
        }
        return this.splitOps;
    }

    private boolean considerSplit() {
        NavigableMap<Revision, Range> previous = this.doc.getPreviousRanges();
        return this.doc.getLocalRevisions().size() + this.doc.getLocalCommitRoot().size() > this.numRevsThreshold || this.doc.getMemory() >= 0x100000 || previous.size() >= 10 || !this.doc.getStalePrev().isEmpty() || this.doc.hasBinary();
    }

    private void populateSplitRevs() {
        for (NavigableMap<Revision, String> splitMap : this.committedChanges.values()) {
            if (!splitMap.isEmpty()) {
                Revision r = (Revision)splitMap.lastKey();
                splitMap.remove(r);
                this.splitRevs.addAll(splitMap.keySet());
                this.hasBinaryToSplit |= this.hasBinaryPropertyForSplit(splitMap.values()) && (Boolean)this.nodeExistsAtHeadRevision.get() != false;
                this.mostRecentRevs.add(r);
            }
            if (splitMap.isEmpty()) continue;
            this.trackHigh((Revision)splitMap.lastKey());
            this.trackLow((Revision)splitMap.firstKey());
            this.numValues += splitMap.size();
        }
    }

    private boolean hasBinaryPropertyForSplit(Iterable<String> values) {
        return this.doc.hasBinary() && Iterables.any((Iterable)Iterables.transform(values, this.binarySize), BINARY_FOR_SPLIT_THRESHOLD);
    }

    private void collectRevisionsAndCommitRoot() {
        TreeMap<Revision, String> revisions = new TreeMap<Revision, String>(StableRevisionComparator.INSTANCE);
        for (Map.Entry<Revision, String> entry : this.doc.getLocalRevisions().entrySet()) {
            if (this.splitRevs.contains(entry.getKey())) {
                revisions.put(entry.getKey(), entry.getValue());
                ++this.numValues;
                continue;
            }
            if (this.context.getClusterId() != entry.getKey().getClusterId() || !Utils.isCommitted(this.context.getCommitValue(entry.getKey(), this.doc)) || this.mostRecentRevs.contains(entry.getKey())) continue;
            revisions.put(entry.getKey(), entry.getValue());
            ++this.numValues;
            this.trackHigh(entry.getKey());
            this.trackLow(entry.getKey());
        }
        this.committedChanges.put("_revisions", revisions);
        TreeMap<Revision, String> commitRoot = new TreeMap<Revision, String>(StableRevisionComparator.INSTANCE);
        boolean mostRecent = true;
        for (Map.Entry<Revision, String> entry : this.doc.getLocalCommitRoot().entrySet()) {
            Revision r = entry.getKey();
            if (this.splitRevs.contains(r)) {
                commitRoot.put(r, entry.getValue());
                ++this.numValues;
                continue;
            }
            if (r.getClusterId() != this.context.getClusterId() || this.changes.contains(r)) continue;
            if (mostRecent && Utils.isCommitted(this.context.getCommitValue(r, this.doc))) {
                mostRecent = false;
                continue;
            }
            if (!this.isGarbage(r)) continue;
            this.addGarbage(r, "_commitRoot");
        }
        this.committedChanges.put("_commitRoot", commitRoot);
    }

    private void createIntermediateDocs() {
        Map<Integer, List<Range>> prevHisto = this.getPreviousDocsHistogram();
        for (Map.Entry<Integer, List<Range>> entry : prevHisto.entrySet()) {
            if (entry.getValue().size() < 10) continue;
            if (this.main == null) {
                this.main = new UpdateOp(this.id, false);
            }
            Revision h = null;
            Revision l = null;
            for (Range r : entry.getValue()) {
                if (h == null || r.high.compareRevisionTime(h) > 0) {
                    h = r.high;
                }
                if (l == null || l.compareRevisionTime(r.low) > 0) {
                    l = r.low;
                }
                NodeDocument.removePrevious(this.main, r);
            }
            if (h == null || l == null) {
                throw new IllegalStateException();
            }
            Path prevPath = Utils.getPreviousPathFor(this.path, h, entry.getKey() + 1);
            String prevId = Utils.getIdFromPath(prevPath);
            UpdateOp intermediate = new UpdateOp(prevId, true);
            if (Utils.isIdFromLongPath(prevId)) {
                intermediate.set("_path", prevPath.toString());
            }
            NodeDocument.setPrevious(this.main, new Range(h, l, entry.getKey() + 1));
            for (Range r : entry.getValue()) {
                NodeDocument.setPrevious(intermediate, r);
            }
            SplitOperations.setIntermediateDocProps(intermediate, Revision.newRevision(this.context.getClusterId()));
            this.splitOps.add(intermediate);
        }
    }

    @Nullable
    private UpdateOp createSplitOps() {
        UpdateOp main = null;
        if (this.high != null && this.low != null && (this.numValues >= this.numRevsThreshold || this.doc.getMemory() > 0x100000 || this.hasBinaryToSplit)) {
            main = new UpdateOp(this.id, false);
            NodeDocument.setPrevious(main, new Range(this.high, this.low, 0));
            Path oldPath = Utils.getPreviousPathFor(this.path, this.high, 0);
            String oldId = Utils.getIdFromPath(oldPath);
            UpdateOp old = new UpdateOp(oldId, true);
            if (Utils.isIdFromLongPath(oldId)) {
                old.set("_path", oldPath.toString());
            }
            for (String property : this.committedChanges.keySet()) {
                NavigableMap<Revision, String> splitMap = this.committedChanges.get(property);
                for (Map.Entry entry : splitMap.entrySet()) {
                    Revision r = (Revision)entry.getKey();
                    if (NodeDocument.isRevisionsEntry(property) || NodeDocument.isCommitRootEntry(property)) {
                        if (!this.mostRecentRevs.contains(r)) {
                            main.removeMapEntry(property, r);
                            NodeDocument.removeBranchCommit(main, r);
                        }
                    } else {
                        main.removeMapEntry(property, r);
                    }
                    old.setMapEntry(property, r, (String)entry.getValue());
                    if (!this.doc.getLocalBranchCommits().contains(r)) continue;
                    NodeDocument.setBranchCommit(old, r);
                }
            }
            NodeDocument oldDoc = new NodeDocument(STORE);
            UpdateUtils.applyChanges(oldDoc, old);
            SplitOperations.setSplitDocProps(this.doc, oldDoc, old, Revision.newRevision(this.context.getClusterId()));
            this.splitOps.add(old);
            if (this.numValues < this.numRevsThreshold) {
                String reason = this.hasBinaryToSplit ? "binary" : "size";
                LOG.debug("Force splitting {} ({})", (Object)this.id, (Object)reason);
            }
        }
        return main;
    }

    private Map<Integer, List<Range>> getPreviousDocsHistogram() {
        HashMap prevHisto = Maps.newHashMap();
        for (Map.Entry entry : this.doc.getPreviousRanges().entrySet()) {
            Revision rev = (Revision)entry.getKey();
            if (rev.getClusterId() != this.context.getClusterId()) continue;
            Range r = (Range)entry.getValue();
            ArrayList<Range> list = (ArrayList<Range>)prevHisto.get(r.getHeight());
            if (list == null) {
                list = new ArrayList<Range>();
                prevHisto.put(r.getHeight(), list);
            }
            list.add(r);
        }
        return prevHisto;
    }

    private void collectLocalChanges(Map<String, NavigableMap<Revision, String>> committedLocally, Set<Revision> changes) {
        for (String property : Sets.filter(this.doc.keySet(), Utils.PROPERTY_OR_DELETED)) {
            TreeMap<Revision, String> splitMap = new TreeMap<Revision, String>(StableRevisionComparator.INSTANCE);
            committedLocally.put(property, splitMap);
            SortedMap<Revision, String> valueMap = this.doc.getLocalMap(property);
            for (Map.Entry entry : valueMap.entrySet()) {
                Revision rev = (Revision)entry.getKey();
                if (rev.getClusterId() != this.context.getClusterId()) continue;
                changes.add(rev);
                if (Utils.isCommitted(this.context.getCommitValue(rev, this.doc))) {
                    splitMap.put(rev, (String)entry.getValue());
                    continue;
                }
                if (!this.isGarbage(rev)) continue;
                this.addGarbage(rev, property);
            }
        }
    }

    private boolean isGarbage(Revision rev) {
        if (this.headRevision.compareRevisionTime(rev) <= 0) {
            return false;
        }
        return this.context.getBranches().getBranchCommit(rev) == null;
    }

    private void addGarbage(Revision rev, String property) {
        if (this.garbageCount > GARBAGE_LIMIT) {
            return;
        }
        HashSet revisions = this.garbage.get(property);
        if (revisions == null) {
            revisions = Sets.newHashSet();
            this.garbage.put(property, revisions);
        }
        if (revisions.add(rev)) {
            ++this.garbageCount;
        }
    }

    private void disconnectStalePrevDocs() {
        NavigableMap<Revision, Range> ranges = this.doc.getPreviousRanges(true);
        for (Map.Entry<Revision, String> entry : this.doc.getStalePrev().entrySet()) {
            Revision r = entry.getKey();
            if (r.getClusterId() != this.context.getClusterId()) continue;
            if (this.main == null) {
                this.main = new UpdateOp(this.id, false);
            }
            NodeDocument.removeStalePrevious(this.main, r);
            if (ranges.containsKey(r) && entry.getValue().equals(String.valueOf(((Range)ranges.get((Object)r)).height))) {
                NodeDocument.removePrevious(this.main, r);
                continue;
            }
            int height = Integer.parseInt(entry.getValue());
            NodeDocument intermediate = this.doc.findPrevReferencingDoc(r, height);
            if (intermediate == null) {
                LOG.warn("Split document {} not referenced anymore. Main document is {}", (Object)Utils.getPreviousIdFor(this.doc.getPath(), r, height), (Object)this.id);
                continue;
            }
            UpdateOp op = new UpdateOp(intermediate.getId(), false);
            NodeDocument.removePrevious(op, r);
            this.splitOps.add(op);
        }
    }

    private void removeGarbage() {
        if (this.garbage.isEmpty()) {
            return;
        }
        if (this.main == null) {
            this.main = new UpdateOp(this.id, false);
        }
        for (Map.Entry<String, Set<Revision>> entry : this.garbage.entrySet()) {
            for (Revision r : entry.getValue()) {
                this.main.removeMapEntry(entry.getKey(), r);
                if (!Utils.PROPERTY_OR_DELETED.apply((Object)entry.getKey())) continue;
                NodeDocument.removeCommitRoot(this.main, r);
                NodeDocument.removeRevision(this.main, r);
                NodeDocument.removeBranchCommit(this.main, r);
            }
        }
    }

    private void trackHigh(Revision r) {
        if (this.high == null || r.compareRevisionTime(this.high) > 0) {
            this.high = r;
        }
    }

    private void trackLow(Revision r) {
        if (this.low == null || this.low.compareRevisionTime(r) > 0) {
            this.low = r;
        }
    }

    private static void setSplitDocProps(NodeDocument mainDoc, NodeDocument oldDoc, UpdateOp old, Revision maxRev) {
        SplitOperations.setSplitDocMaxRev(old, maxRev);
        NodeDocument.SplitDocType type = NodeDocument.SplitDocType.DEFAULT;
        if (!mainDoc.hasChildren()) {
            type = NodeDocument.SplitDocType.DEFAULT_LEAF;
        } else if (oldDoc.getLocalRevisions().isEmpty()) {
            type = NodeDocument.SplitDocType.COMMIT_ROOT_ONLY;
        } else if (oldDoc.getLocalBranchCommits().isEmpty()) {
            type = NodeDocument.SplitDocType.DEFAULT_NO_BRANCH;
        }
        if (mainDoc.hasBinary()) {
            NodeDocument.setHasBinary(old);
        }
        SplitOperations.setSplitDocType(old, type);
    }

    private static void setIntermediateDocProps(UpdateOp intermediate, Revision maxRev) {
        SplitOperations.setSplitDocMaxRev(intermediate, maxRev);
        SplitOperations.setSplitDocType(intermediate, NodeDocument.SplitDocType.INTERMEDIATE);
    }

    private static void setSplitDocType(@NotNull UpdateOp op, @NotNull NodeDocument.SplitDocType type) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set("_sdType", type.type);
    }

    private static void setSplitDocMaxRev(@NotNull UpdateOp op, @NotNull Revision maxRev) {
        ((UpdateOp)Preconditions.checkNotNull((Object)op)).set("_sdMaxRevTime", NodeDocument.getModifiedInSecs(maxRev.getTimestamp()));
    }
}

