/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;

public class SegmentNodeStoreBuilder {
    private final SegmentStore store;
    private boolean isCreated;
    private CompactionStrategy compactionStrategy = CompactionStrategy.NO_COMPACTION;
    private volatile SegmentNodeStore segmentNodeStore;

    static SegmentNodeStoreBuilder newSegmentNodeStore(SegmentStore store) {
        return new SegmentNodeStoreBuilder(store);
    }

    private SegmentNodeStoreBuilder(@Nonnull SegmentStore store) {
        this.store = store;
    }

    @Deprecated
    public SegmentNodeStoreBuilder withCompactionStrategy(boolean pauseCompaction, boolean cloneBinaries, String cleanup, long cleanupTs, byte memoryThreshold, int lockWaitTime, int retryCount, boolean forceAfterFail, boolean persistCompactionMap) {
        return this.withCompactionStrategy(pauseCompaction, cloneBinaries, cleanup, cleanupTs, memoryThreshold, lockWaitTime, retryCount, forceAfterFail, persistCompactionMap, (byte)10);
    }

    public SegmentNodeStoreBuilder withCompactionStrategy(CompactionStrategy compactionStrategy) {
        this.compactionStrategy = compactionStrategy;
        return this;
    }

    public SegmentNodeStoreBuilder withCompactionStrategy(boolean pauseCompaction, boolean cloneBinaries, String cleanup, long cleanupTs, byte memoryThreshold, final int lockWaitTime, int retryCount, boolean forceAfterFail, boolean persistCompactionMap, byte gainThreshold) {
        this.compactionStrategy = new CompactionStrategy(pauseCompaction, cloneBinaries, CompactionStrategy.CleanupType.valueOf(cleanup), cleanupTs, memoryThreshold){

            @Override
            public boolean compacted(Callable<Boolean> setHead) throws Exception {
                return SegmentNodeStoreBuilder.this.segmentNodeStore.locked(setHead, lockWaitTime, TimeUnit.SECONDS);
            }
        };
        this.compactionStrategy.setRetryCount(retryCount);
        this.compactionStrategy.setForceAfterFail(forceAfterFail);
        this.compactionStrategy.setPersistCompactionMap(persistCompactionMap);
        this.compactionStrategy.setGainThreshold(gainThreshold);
        return this;
    }

    public CompactionStrategy getCompactionStrategy() {
        Preconditions.checkState((boolean)this.isCreated);
        return this.compactionStrategy;
    }

    @Nonnull
    public SegmentNodeStore create() {
        Preconditions.checkState((!this.isCreated ? 1 : 0) != 0);
        this.isCreated = true;
        this.segmentNodeStore = new SegmentNodeStore(this.store, true);
        return this.segmentNodeStore;
    }
}

