/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;

class PropertyTemplate
implements Comparable<PropertyTemplate> {
    private final int index;
    private final String name;
    private final Type<?> type;

    PropertyTemplate(int index, String name, Type<?> type) {
        this.index = index;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.type = (Type)Preconditions.checkNotNull(type);
    }

    PropertyTemplate(PropertyState state) {
        Preconditions.checkNotNull((Object)state);
        this.index = 0;
        this.name = state.getName();
        this.type = state.getType();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Type<?> getType() {
        return this.type;
    }

    @Override
    public int compareTo(@Nonnull PropertyTemplate template) {
        Preconditions.checkNotNull((Object)template);
        return ComparisonChain.start().compare(this.hashCode(), template.hashCode()).compare((Comparable)((Object)this.name), (Comparable)((Object)template.name)).compare(this.type, template.type).result();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PropertyTemplate) {
            PropertyTemplate that = (PropertyTemplate)object;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + "(" + this.type + ")";
    }
}

