/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.memory;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MemoryStore
implements SegmentStore {
    private final SegmentTracker tracker = new SegmentTracker(this, 16, SegmentVersion.V_11);
    private SegmentNodeState head;
    private final ConcurrentMap<SegmentId, Segment> segments = Maps.newConcurrentMap();

    public MemoryStore(NodeState root) throws IOException {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        builder.setChildNode("root", root);
        SegmentWriter writer = this.tracker.getWriter();
        this.head = writer.writeNode(builder.getNodeState());
        writer.flush();
    }

    public MemoryStore() throws IOException {
        this(EmptyNodeState.EMPTY_NODE);
    }

    @Override
    public SegmentTracker getTracker() {
        return this.tracker;
    }

    @Override
    public synchronized SegmentNodeState getHead() {
        return this.head;
    }

    @Override
    public synchronized boolean setHead(SegmentNodeState base, SegmentNodeState head) {
        if (this.head.getRecordId().equals(base.getRecordId())) {
            this.head = head;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return id.getTracker() == this.tracker || this.segments.containsKey(id);
    }

    @Override
    @Nonnull
    public Segment readSegment(SegmentId id) {
        Segment segment = (Segment)this.segments.get(id);
        if (segment != null) {
            return segment;
        }
        throw new SegmentNotFoundException(id);
    }

    @Override
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(data, offset, length);
        buffer.rewind();
        Segment segment = new Segment(this.tracker, id, buffer);
        if (this.segments.putIfAbsent(id, segment) != null) {
            throw new IOException("Segment override: " + id);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Blob readBlob(String reference) {
        return null;
    }

    @Override
    public BlobStore getBlobStore() {
        return null;
    }

    @Override
    public void gc() {
        System.gc();
        this.segments.keySet().retainAll(this.tracker.getReferencedSegmentIds());
    }
}

