/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.segment.SegmentCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategyMBean;
import org.apache.jackrabbit.oak.plugins.segment.compaction.DefaultCompactionStrategyMBean;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreGCMonitor;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.plugins.segment.file.GCMonitorMBean;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ProxyNodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Segment NodeStore Service", description="NodeStore implementation based on Document model. For configuration option refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#SegmentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported")
public class SegmentNodeStoreService
extends ProxyNodeStore
implements Observable,
SegmentStoreProvider {
    public static final String NAME = "name";
    @Property(label="Directory", description="Directory location used to store the segment tar files. If not specified then looks for framework property 'repository.home' otherwise use a subdirectory with name 'tarmk'")
    public static final String DIRECTORY = "repository.home";
    @Property(label="Mode", description="TarMK mode (64 for memory mapping, 32 for normal file access)")
    public static final String MODE = "tarmk.mode";
    @Property(intValue={256}, label="Maximum Tar File Size (MB)", description="TarMK maximum file size (MB)")
    public static final String SIZE = "tarmk.size";
    @Property(intValue={256}, label="Cache size (MB)", description="Cache size for storing most recently used Segments")
    public static final String CACHE = "cache";
    @Property(boolValue={false}, label="Clone Binaries", description="Clone the binary segments while performing compaction")
    public static final String COMPACTION_CLONE_BINARIES = "compaction.cloneBinaries";
    @Property(options={@PropertyOption(name="CLEAN_ALL", value="CLEAN_ALL"), @PropertyOption(name="CLEAN_NONE", value="CLEAN_NONE"), @PropertyOption(name="CLEAN_OLD", value="CLEAN_OLD")}, value={"CLEAN_OLD"}, label="Cleanup Strategy", description="Cleanup strategy used for live in memory segment references while performing cleanup. 1. CLEAN_NONE: All in memory references are considered valid, 2. CLEAN_OLD: Only in memory references older than a certain age are considered valid (compaction.cleanup.timestamp), 3. CLEAN_ALL: None of the in memory references are considered valid")
    public static final String COMPACTION_CLEANUP = "compaction.cleanup";
    @Property(longValue={36000000L}, label="Reference expiry time (ms)", description="Time interval in ms beyond which in memory segment references would be ignored while performing cleanup")
    public static final String COMPACTION_CLEANUP_TIMESTAMP = "compaction.cleanup.timestamp";
    @Property(byteValue={5}, label="Memory Multiplier", description="TarMK compaction available memory multiplier needed to run compaction")
    public static final String COMPACTION_MEMORY_THRESHOLD = "compaction.memoryThreshold";
    @Property(byteValue={10}, label="Compaction gain threshold", description="TarMK compaction gain threshold. The gain estimation prevents compaction from running if the provided threshold is not met. Value represents a percentage so an input beween 0 and 100 is expected.")
    public static final String COMPACTION_GAIN_THRESHOLD = "compaction.gainThreshold";
    @Property(boolValue={true}, label="Pause Compaction", description="When enabled compaction would not be performed")
    public static final String PAUSE_COMPACTION = "pauseCompaction";
    @Property(intValue={5}, label="Compaction Retries", description="Number of tries to compact concurrent commits on top of already compacted commits")
    public static final String COMPACTION_RETRY_COUNT = "compaction.retryCount";
    @Property(boolValue={false}, label="Force Compaction", description="Whether or not to force compact concurrent commits on top of already  compacted commits after the maximum number of retries has been reached. Force committing tries to exclusively write lock the node store.")
    public static final String COMPACTION_FORCE_AFTER_FAIL = "compaction.forceAfterFail";
    public static final int COMPACTION_LOCK_WAIT_TIME_DEFAULT = 60;
    @Property(intValue={60}, label="Compaction Lock Wait Time", description="Number of seconds to wait for the lock for committing compacted changes respectively to wait for the exclusive write lock for force committing.")
    public static final String COMPACTION_LOCK_WAIT_TIME = "compaction.lockWaitTime";
    @Property(boolValue={true}, label="Persist Compaction Map", description="When enabled the compaction map would be persisted instead of being held in memory")
    public static final String PERSIST_COMPACTION_MAP = "persistCompactionMap";
    @Property(boolValue={false}, label="Standby Mode", description="Flag indicating that this component will not register as a NodeStore but just as a NodeStoreProvider")
    public static final String STANDBY = "standby";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default large binary content would be stored within segment tar files")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private FileStore store;
    private volatile SegmentNodeStore delegate;
    private ObserverTracker observerTracker;
    private GCMonitorTracker gcMonitor;
    private ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private ServiceRegistration storeRegistration;
    private ServiceRegistration providerRegistration;
    private Registration checkpointRegistration;
    private Registration revisionGCRegistration;
    private Registration blobGCRegistration;
    private Registration compactionStrategyRegistration;
    private Registration segmentCacheMBean;
    private Registration stringCacheMBean;
    private Registration fsgcMonitorMBean;
    private Registration fileStoreStatsMBean;
    private WhiteboardExecutor executor;
    private boolean customBlobStore;
    private static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Blob GC Max Age (in secs)", description="Blob Garbage Collector (GC) logic will only consider those blobs for GC which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example as per default only those blobs which have been created 24 hrs ago will be considered for GC")
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";

    protected SegmentNodeStore getNodeStore() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"service must be activated when used");
        return this.delegate;
    }

    @Activate
    private void activate(ComponentContext context) throws IOException {
        this.context = context;
        this.customBlobStore = Boolean.parseBoolean(this.property(CUSTOM_BLOB_STORE));
        if (this.blobStore == null && this.customBlobStore) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
    }

    public void registerNodeStore() throws IOException {
        if (this.registerSegmentStore()) {
            boolean standby = PropertiesUtil.toBoolean((Object)this.property(STANDBY), (boolean)false);
            this.providerRegistration = this.context.getBundleContext().registerService(SegmentStoreProvider.class.getName(), (Object)this, null);
            if (!standby) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("service.pid", SegmentNodeStore.class.getName());
                ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=segment"});
                this.storeRegistration = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)this, props);
            }
        }
    }

    public synchronized boolean registerSegmentStore() throws IOException {
        String cache;
        String size;
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return false;
        }
        Dictionary properties = this.context.getProperties();
        this.name = String.valueOf(properties.get(NAME));
        String directory = this.property(DIRECTORY);
        directory = directory == null ? "tarmk" : FilenameUtils.concat((String)directory, (String)"segmentstore");
        String mode = this.property(MODE);
        if (mode == null) {
            mode = System.getProperty(MODE, System.getProperty("sun.arch.data.model", "32"));
        }
        if ((size = this.property(SIZE)) == null) {
            size = System.getProperty(SIZE, "256");
        }
        if ((cache = this.property(CACHE)) == null) {
            cache = System.getProperty(CACHE);
        }
        boolean pauseCompaction = PropertiesUtil.toBoolean((Object)this.property(PAUSE_COMPACTION), (boolean)true);
        boolean cloneBinaries = PropertiesUtil.toBoolean((Object)this.property(COMPACTION_CLONE_BINARIES), (boolean)false);
        long cleanupTs = PropertiesUtil.toLong((Object)this.property(COMPACTION_CLEANUP_TIMESTAMP), (long)36000000L);
        int retryCount = PropertiesUtil.toInteger((Object)this.property(COMPACTION_RETRY_COUNT), (int)5);
        boolean forceCommit = PropertiesUtil.toBoolean((Object)this.property(COMPACTION_FORCE_AFTER_FAIL), (boolean)false);
        int lockWaitTime = PropertiesUtil.toInteger((Object)this.property(COMPACTION_LOCK_WAIT_TIME), (int)60);
        boolean persistCompactionMap = PropertiesUtil.toBoolean((Object)this.property(PERSIST_COMPACTION_MAP), (boolean)true);
        String cleanup = this.property(COMPACTION_CLEANUP);
        if (cleanup == null) {
            cleanup = CompactionStrategy.CLEANUP_DEFAULT.toString();
        }
        String memoryThresholdS = this.property(COMPACTION_MEMORY_THRESHOLD);
        byte memoryThreshold = 5;
        if (memoryThresholdS != null) {
            memoryThreshold = Byte.valueOf(memoryThresholdS);
        }
        String gainThresholdS = this.property(COMPACTION_GAIN_THRESHOLD);
        byte gainThreshold = 10;
        if (gainThresholdS != null) {
            gainThreshold = Byte.valueOf(gainThresholdS);
        }
        long blobGcMaxAgeInSecs = PropertiesUtil.toLong((Object)this.property(PROP_BLOB_GC_MAX_AGE), (long)86400L);
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.gcMonitor = new GCMonitorTracker();
        this.gcMonitor.start((Whiteboard)whiteboard);
        FileStore.Builder storeBuilder = FileStore.newFileStore(new File(directory)).withCacheSize(Integer.parseInt(cache)).withMaxFileSize(Integer.parseInt(size)).withMemoryMapping("64".equals(mode)).withGCMonitor((GCMonitor)this.gcMonitor).withStatisticsProvider(this.statisticsProvider);
        if (this.customBlobStore) {
            this.log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)this.blobStore);
            this.store = storeBuilder.withBlobStore(this.blobStore).create();
        } else {
            this.store = storeBuilder.create();
        }
        SegmentNodeStoreBuilder nodeStoreBuilder = SegmentNodeStore.newSegmentNodeStore(this.store);
        nodeStoreBuilder.withCompactionStrategy(pauseCompaction, cloneBinaries, cleanup, cleanupTs, memoryThreshold, lockWaitTime, retryCount, forceCommit, persistCompactionMap, gainThreshold);
        this.delegate = nodeStoreBuilder.create();
        CompactionStrategy compactionStrategy = nodeStoreBuilder.getCompactionStrategy();
        this.store.setCompactionStrategy(compactionStrategy);
        CacheStats segmentCacheStats = this.store.getTracker().getSegmentCacheStats();
        this.segmentCacheMBean = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)segmentCacheStats, (String)"CacheStats", (String)segmentCacheStats.getName());
        CacheStats stringCacheStats = this.store.getTracker().getStringCacheStats();
        if (stringCacheStats != null) {
            this.stringCacheMBean = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CacheStatsMBean.class, (Object)stringCacheStats, (String)"CacheStats", (String)stringCacheStats.getName());
        }
        FileStoreGCMonitor fsgcMonitor = new FileStoreGCMonitor(Clock.SIMPLE);
        this.fsgcMonitorMBean = new CompositeRegistration(new Registration[]{whiteboard.register(GCMonitor.class, (Object)fsgcMonitor, Collections.emptyMap()), WhiteboardUtils.registerMBean((Whiteboard)whiteboard, GCMonitorMBean.class, (Object)fsgcMonitor, (String)"GC Monitor", (String)"File Store garbage collection monitor"), WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)whiteboard, (Runnable)fsgcMonitor, (long)1L)});
        this.observerTracker = new ObserverTracker((Observable)this.delegate);
        this.observerTracker.start(this.context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start((Whiteboard)whiteboard);
        this.checkpointRegistration = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CheckpointMBean.class, (Object)((Object)new SegmentCheckpointMBean(this.delegate)), (String)"CheckpointManger", (String)"Segment node store checkpoint management");
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                SegmentNodeStoreService.this.store.gc();
            }
        }, (Executor)this.executor);
        this.revisionGCRegistration = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, RevisionGCMBean.class, (Object)revisionGC, (String)"RevisionGarbageCollection", (String)"Segment node store revision garbage collection");
        GenericDescriptors clusterIdDesc = new GenericDescriptors();
        clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId((NodeStore)this.delegate)), true, false);
        whiteboard.register(Descriptors.class, (Object)clusterIdDesc, Collections.emptyMap());
        String repoId = "";
        if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
            try {
                repoId = ClusterRepositoryInfo.getOrCreateId((NodeStore)this.delegate);
                ((SharedDataStore)this.blobStore).addMetadataRecord((InputStream)new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(repoId));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
        }
        if (this.store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector((BlobReferenceRetriever)new SegmentBlobReferenceRetriever(this.store.getTracker()), (GarbageCollectableBlobStore)this.store.getBlobStore(), (Executor)this.executor, TimeUnit.SECONDS.toMillis(blobGcMaxAgeInSecs), repoId);
            this.blobGCRegistration = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, BlobGCMBean.class, (Object)new BlobGC((BlobGarbageCollector)gc, (Executor)this.executor), (String)"BlobGarbageCollection", (String)"Segment node store blob garbage collection");
        }
        this.compactionStrategyRegistration = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, CompactionStrategyMBean.class, (Object)new DefaultCompactionStrategyMBean(compactionStrategy), (String)"CompactionStrategy", (String)"Segment node store compaction strategy settings");
        this.fileStoreStatsMBean = WhiteboardUtils.registerMBean((Whiteboard)whiteboard, FileStoreStatsMBean.class, (Object)this.store.getStats(), (String)"FileStoreStats", (String)"FileStore statistics");
        this.log.info("SegmentNodeStore initialized");
        return true;
    }

    private String property(String name) {
        return OsgiUtil.lookupConfigurationThenFramework((ComponentContext)this.context, (String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        this.unregisterNodeStore();
        SegmentNodeStoreService segmentNodeStoreService = this;
        synchronized (segmentNodeStoreService) {
            if (this.observerTracker != null) {
                this.observerTracker.stop();
            }
            if (this.gcMonitor != null) {
                this.gcMonitor.stop();
            }
            this.delegate = null;
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
        }
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        if (this.segmentCacheMBean != null) {
            this.segmentCacheMBean.unregister();
            this.segmentCacheMBean = null;
        }
        if (this.stringCacheMBean != null) {
            this.stringCacheMBean.unregister();
            this.stringCacheMBean = null;
        }
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
            this.providerRegistration = null;
        }
        if (this.storeRegistration != null) {
            this.storeRegistration.unregister();
            this.storeRegistration = null;
        }
        if (this.checkpointRegistration != null) {
            this.checkpointRegistration.unregister();
            this.checkpointRegistration = null;
        }
        if (this.revisionGCRegistration != null) {
            this.revisionGCRegistration.unregister();
            this.revisionGCRegistration = null;
        }
        if (this.blobGCRegistration != null) {
            this.blobGCRegistration.unregister();
            this.blobGCRegistration = null;
        }
        if (this.compactionStrategyRegistration != null) {
            this.compactionStrategyRegistration.unregister();
            this.compactionStrategyRegistration = null;
        }
        if (this.fsgcMonitorMBean != null) {
            this.fsgcMonitorMBean.unregister();
            this.fsgcMonitorMBean = null;
        }
        if (this.fileStoreStatsMBean != null) {
            this.fileStoreStatsMBean.unregister();
            this.fileStoreStatsMBean = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    @Override
    public SegmentStore getSegmentStore() {
        return this.store;
    }

    public Closeable addObserver(Observer observer) {
        return this.getNodeStore().addObserver(observer);
    }

    public String toString() {
        return this.name + ": " + this.delegate;
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }
}

