/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.segment.Compactor;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreRestore {
    private static final Logger log = LoggerFactory.getLogger(FileStoreRestore.class);
    static int MAX_FILE_SIZE = 256;
    private static final String JOURNAL_FILE_NAME = "journal.log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restore(File source, File destination) throws IOException {
        if (!FileStoreRestore.validFileStore(source)) {
            throw new IOException("Folder " + source + " is not a valid FileStore directory");
        }
        FileStore.ReadOnlyStore restore = new FileStore.ReadOnlyStore(source);
        Stopwatch watch = Stopwatch.createStarted();
        FileStore store = FileStore.newFileStore(destination).create();
        SegmentNodeState current = store.getHead();
        try {
            Compactor compactor = new Compactor(store.getTracker());
            compactor.setDeepCheckLargeBinaries(true);
            SegmentNodeState after = compactor.compact(current, restore.getHead(), current);
            store.setHead(current, after);
        }
        finally {
            restore.close();
            store.close();
        }
        watch.stop();
        log.info("Restore finished in {}.", (Object)watch);
    }

    public static void restore(File source, NodeStore store) {
        log.warn("Restore not available as an online operation.");
    }

    private static boolean validFileStore(File source) {
        if (source == null || !source.isDirectory()) {
            return false;
        }
        for (String f : source.list()) {
            if (!JOURNAL_FILE_NAME.equals(f)) continue;
            return true;
        }
        return false;
    }
}

