/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

final class PrintingDiff
implements NodeStateDiff {
    private static final Function<Blob, String> BLOB_LENGTH = new Function<Blob, String>(){

        public String apply(Blob b) {
            return this.safeGetLength(b);
        }

        private String safeGetLength(Blob b) {
            try {
                return FileUtils.byteCountToDisplaySize((long)b.length());
            }
            catch (IllegalStateException illegalStateException) {
                return "[N/A]";
            }
        }
    };
    private final PrintWriter pw;
    private final String path;

    PrintingDiff(PrintWriter pw, String path) {
        this.pw = pw;
        this.path = path;
    }

    public boolean propertyAdded(PropertyState after) {
        this.pw.println("    + " + PrintingDiff.toString(after));
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.pw.println("    ^ " + before.getName());
        this.pw.println("      - " + PrintingDiff.toString(before));
        this.pw.println("      + " + PrintingDiff.toString(after));
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.pw.println("    - " + PrintingDiff.toString(before));
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        String p = PathUtils.concat((String)this.path, (String)name);
        this.pw.println("+ " + p);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)new PrintingDiff(this.pw, p));
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        String p = PathUtils.concat((String)this.path, (String)name);
        this.pw.println("^ " + p);
        return after.compareAgainstBaseState(before, (NodeStateDiff)new PrintingDiff(this.pw, p));
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        String p = PathUtils.concat((String)this.path, (String)name);
        this.pw.println("- " + p);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, (NodeStateDiff)new PrintingDiff(this.pw, p));
    }

    private static String toString(PropertyState ps) {
        StringBuilder val = new StringBuilder();
        val.append(ps.getName()).append("<").append(ps.getType()).append(">");
        if (ps.getType() == Type.BINARY) {
            String v = (String)BLOB_LENGTH.apply(ps.getValue(Type.BINARY));
            val.append(" = {").append(v).append("}");
        } else if (ps.getType() == Type.BINARIES) {
            String v = Iterables.transform((Iterable)((Iterable)ps.getValue(Type.BINARIES)), BLOB_LENGTH).toString();
            val.append("[").append(ps.count()).append("] = ").append(v);
        } else if (ps.isArray()) {
            val.append("[").append(ps.count()).append("] = ").append(ps.getValue(Type.STRINGS));
        } else {
            val.append(" = ").append((String)ps.getValue(Type.STRING));
        }
        return ps.getName() + "<" + ps.getType() + ">" + val.toString();
    }
}

