/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupImpl;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class Backup
implements Runnable {
    private final File source;
    private final File target;
    private final boolean fakeBlobStore;
    private final FileStoreBackup fileStoreBackup;

    public static Builder builder() {
        return new Builder();
    }

    private Backup(Builder builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.fakeBlobStore = builder.fakeBlobStore;
        this.fileStoreBackup = builder.fileStoreBackup;
    }

    @Override
    public void run() {
        try (ReadOnlyFileStore fs = this.newFileStore();){
            this.fileStoreBackup.backup(fs.getReader(), fs.getRevisions(), this.target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ReadOnlyFileStore newFileStore() throws IOException, InvalidFileStoreVersionException {
        if (this.fakeBlobStore) {
            return Utils.openReadOnlyFileStore(this.source, Utils.newBasicReadOnlyBlobStore());
        }
        return Utils.openReadOnlyFileStore(this.source);
    }

    public static class Builder {
        private File source;
        private File target;
        private boolean fakeBlobStore = FileStoreBackupImpl.USE_FAKE_BLOBSTORE;
        private final FileStoreBackup fileStoreBackup = new FileStoreBackupImpl();

        private Builder() {
        }

        public Builder withSource(File source) {
            this.source = (File)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withTarget(File target) {
            this.target = (File)Preconditions.checkNotNull((Object)target);
            return this;
        }

        public Builder withFakeBlobStore(boolean fakeBlobStore) {
            this.fakeBlobStore = fakeBlobStore;
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull((Object)this.source);
            Preconditions.checkNotNull((Object)this.target);
            return new Backup(this);
        }
    }
}

